/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.ComponentCategory;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorException;
import org.eobjects.analyzer.descriptors.SimpleComponentDescriptor;
import org.eobjects.analyzer.util.ReflectionUtils;

abstract class AbstractBeanDescriptor<B>
extends SimpleComponentDescriptor<B>
implements BeanDescriptor<B> {
    private static final long serialVersionUID = 1L;
    private final boolean _requireInputColumns;

    public AbstractBeanDescriptor(Class<B> beanClass, boolean requireInputColumns) {
        super(beanClass);
        this._requireInputColumns = requireInputColumns;
    }

    @Override
    protected void visitClass() {
        super.visitClass();
        if (this._requireInputColumns) {
            int numConfiguredColumns = 0;
            int numConfiguredColumnArrays = 0;
            for (ConfiguredPropertyDescriptor cd : this._configuredProperties) {
                if (!cd.isInputColumn()) continue;
                if (cd.isArray()) {
                    ++numConfiguredColumnArrays;
                    continue;
                }
                ++numConfiguredColumns;
            }
            int totalColumns = numConfiguredColumns + numConfiguredColumnArrays;
            if (totalColumns == 0) {
                throw new DescriptorException(this.getComponentClass() + " does not define a @Configured InputColumn or InputColumn-array");
            }
        }
    }

    @Override
    public Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesForInput() {
        return this.getConfiguredPropertiesForInput(true);
    }

    @Override
    public Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesForInput(boolean includeOptional) {
        TreeSet<ConfiguredPropertyDescriptor> descriptors = new TreeSet<ConfiguredPropertyDescriptor>(this._configuredProperties);
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            ConfiguredPropertyDescriptor propertyDescriptor = (ConfiguredPropertyDescriptor)it.next();
            if (!propertyDescriptor.isInputColumn()) {
                it.remove();
                continue;
            }
            if (includeOptional || propertyDescriptor.isRequired()) continue;
            it.remove();
        }
        return descriptors;
    }

    @Override
    public String getDescription() {
        Description description = this.getAnnotation(Description.class);
        if (description == null) {
            return null;
        }
        return description.value();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return ReflectionUtils.getAnnotation(this.getComponentClass(), annotationClass);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        Annotation[] annotations = this.getComponentClass().getAnnotations();
        return new HashSet<Annotation>(Arrays.asList(annotations));
    }

    @Override
    public Set<ComponentCategory> getComponentCategories() {
        Categorized categorized = this.getAnnotation(Categorized.class);
        if (categorized == null) {
            return Collections.emptySet();
        }
        Class[] value = categorized.value();
        if (value == null || value.length == 0) {
            return Collections.emptySet();
        }
        HashSet<ComponentCategory> result = new HashSet<ComponentCategory>();
        for (Class categoryClass : value) {
            ComponentCategory category = (ComponentCategory)ReflectionUtils.newInstance(categoryClass);
            result.add(category);
        }
        return result;
    }

    @Override
    public String[] getAliases() {
        Alias alias = this.getAnnotation(Alias.class);
        if (alias == null) {
            return new String[0];
        }
        return alias.value();
    }
}

