/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.Renderer;
import org.eobjects.analyzer.beans.api.RenderingFormat;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorProvider;
import org.eobjects.analyzer.descriptors.ExplorerBeanDescriptor;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.RendererBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;

public abstract class AbstractDescriptorProvider
implements DescriptorProvider {
    @Override
    public final AnalyzerBeanDescriptor<?> getAnalyzerBeanDescriptorByDisplayName(String name) {
        return this.getBeanDescriptorByDisplayName(name, this.getAnalyzerBeanDescriptors());
    }

    @Override
    public final ExplorerBeanDescriptor<?> getExplorerBeanDescriptorByDisplayName(String name) {
        return this.getBeanDescriptorByDisplayName(name, this.getExplorerBeanDescriptors());
    }

    protected <A extends Analyzer<?>> AnalyzerBeanDescriptor<A> notFoundAnalyzer(Class<A> analyzerClass) {
        return null;
    }

    protected <E extends Explorer<?>> ExplorerBeanDescriptor<E> notFoundExplorer(Class<E> explorerClass) {
        return null;
    }

    protected <A extends Transformer<?>> TransformerBeanDescriptor<A> notFoundTransformer(Class<A> transformerClass) {
        return null;
    }

    protected FilterBeanDescriptor<?, ?> notFoundFilter(Class<?> filterClass) {
        return null;
    }

    protected <R extends Renderer<?, ?>> RendererBeanDescriptor<R> notFoundRenderer(Class<R> rendererClass) {
        return null;
    }

    @Override
    public final <A extends Analyzer<?>> AnalyzerBeanDescriptor<A> getAnalyzerBeanDescriptorForClass(Class<A> analyzerBeanClass) {
        for (AnalyzerBeanDescriptor<?> descriptor : this.getAnalyzerBeanDescriptors()) {
            if (descriptor.getComponentClass() != analyzerBeanClass) continue;
            return descriptor;
        }
        return this.notFoundAnalyzer(analyzerBeanClass);
    }

    @Override
    public final <E extends Explorer<?>> ExplorerBeanDescriptor<E> getExplorerBeanDescriptorForClass(Class<E> explorerClass) {
        for (ExplorerBeanDescriptor<?> descriptor : this.getExplorerBeanDescriptors()) {
            if (descriptor.getComponentClass() != explorerClass) continue;
            return descriptor;
        }
        return this.notFoundExplorer(explorerClass);
    }

    @Override
    public final FilterBeanDescriptor<?, ?> getFilterBeanDescriptorByDisplayName(String name) {
        return this.getBeanDescriptorByDisplayName(name, this.getFilterBeanDescriptors());
    }

    @Override
    public final <F extends Filter<C>, C extends Enum<C>> FilterBeanDescriptor<F, C> getFilterBeanDescriptorForClass(Class<F> filterClass) {
        return this.getFilterBeanDescriptorForClassUnbounded(filterClass);
    }

    protected final FilterBeanDescriptor<?, ?> getFilterBeanDescriptorForClassUnbounded(Class<?> filterClass) {
        for (FilterBeanDescriptor<?, ?> descriptor : this.getFilterBeanDescriptors()) {
            if (filterClass != descriptor.getComponentClass()) continue;
            return descriptor;
        }
        return this.notFoundFilter(filterClass);
    }

    @Override
    public final <R extends Renderer<?, ?>> RendererBeanDescriptor<R> getRendererBeanDescriptorForClass(Class<R> rendererBeanClass) {
        for (RendererBeanDescriptor<?> descriptor : this.getRendererBeanDescriptors()) {
            if (descriptor.getComponentClass() != rendererBeanClass) continue;
            RendererBeanDescriptor<?> result = descriptor;
            return result;
        }
        return this.notFoundRenderer(rendererBeanClass);
    }

    @Override
    public final TransformerBeanDescriptor<?> getTransformerBeanDescriptorByDisplayName(String name) {
        return this.getBeanDescriptorByDisplayName(name, this.getTransformerBeanDescriptors());
    }

    @Override
    public final <T extends Transformer<?>> TransformerBeanDescriptor<T> getTransformerBeanDescriptorForClass(Class<T> transformerClass) {
        for (TransformerBeanDescriptor<?> descriptor : this.getTransformerBeanDescriptors()) {
            if (descriptor.getComponentClass() != transformerClass) continue;
            return descriptor;
        }
        return this.notFoundTransformer(transformerClass);
    }

    @Override
    public final Collection<RendererBeanDescriptor<?>> getRendererBeanDescriptorsForRenderingFormat(Class<? extends RenderingFormat<?>> renderingFormat) {
        ArrayList result = new ArrayList();
        Collection<RendererBeanDescriptor<?>> descriptors = this.getRendererBeanDescriptors();
        for (RendererBeanDescriptor<?> descriptor : descriptors) {
            Class<RenderingFormat<?>> descriptorsRenderingFormat = descriptor.getRenderingFormat();
            if (descriptorsRenderingFormat != renderingFormat) continue;
            result.add(descriptor);
        }
        return result;
    }

    private <E extends BeanDescriptor<?>> E getBeanDescriptorByDisplayName(String name, Collection<E> descriptors) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        for (BeanDescriptor descriptor : descriptors) {
            String displayName = descriptor.getDisplayName();
            if (!name.equals(displayName)) continue;
            return (E)descriptor;
        }
        for (BeanDescriptor descriptor : descriptors) {
            Object[] aliases = descriptor.getAliases();
            if (!ArrayUtils.contains((Object[])aliases, (Object)name)) continue;
            return (E)descriptor;
        }
        return null;
    }
}

