/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorException;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.util.BaseObject;

class AbstractMethodDescriptor
extends BaseObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Method _method;
    private final ComponentDescriptor<?> _componentDescriptor;
    private final String _name;

    public AbstractMethodDescriptor(Method method, ComponentDescriptor<?> componentDescriptor) {
        if (method.getReturnType() != Void.TYPE) {
            throw new DescriptorException("Method can only be void");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            throw new DescriptorException("Method cannot have parameters");
        }
        this._method = method;
        this._method.setAccessible(true);
        this._name = method.getName();
        this._componentDescriptor = componentDescriptor;
    }

    public final Method getMethod() {
        if (this._method == null) {
            return ReflectionUtils.getMethod(this._componentDescriptor.getComponentClass(), this._name);
        }
        return this._method;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[method=" + this._name + "]";
    }

    protected final void invoke(Object component) {
        try {
            this._method.invoke(component, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new IllegalStateException("Invoked method threw exception", targetException);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not invoke method " + this.getMethod(), e);
        }
    }

    public final Set<Annotation> getAnnotations() {
        Annotation[] annotations = this.getMethod().getAnnotations();
        return new HashSet<Annotation>(Arrays.asList(annotations));
    }

    public final <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return ReflectionUtils.getAnnotation(this.getMethod(), annotationClass);
    }

    protected void decorateIdentity(List<Object> list) {
        list.add(this.getMethod());
    }
}

