/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.descriptors.PropertyDescriptor;
import org.eobjects.analyzer.util.ReflectionUtils;

public abstract class AbstractPropertyDescriptor
implements PropertyDescriptor {
    private static final long serialVersionUID = 1L;
    private final transient Field _field;
    private final transient Type _genericType;
    private final String _name;
    private final Class<?> _baseType;
    private final ComponentDescriptor<?> _componentDescriptor;

    public AbstractPropertyDescriptor(Field field, ComponentDescriptor<?> componentDescriptor) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        this._field = field;
        this._field.setAccessible(true);
        this._name = this._field.getName();
        this._baseType = this._field.getType();
        this._genericType = this._field.getGenericType();
        this._componentDescriptor = componentDescriptor;
    }

    public Field getField() {
        if (this._field == null) {
            return ReflectionUtils.getField(this._componentDescriptor.getComponentClass(), this._name);
        }
        return this._field;
    }

    public Type getGenericType() {
        if (this._genericType == null) {
            return this.getField().getGenericType();
        }
        return this._genericType;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setValue(Object component, Object value) throws IllegalArgumentException {
        try {
            this.getField().set(component, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not assign value '" + value + "' to " + this._field, e);
        }
    }

    @Override
    public Object getValue(Object bean) throws IllegalArgumentException {
        if (bean == null) {
            throw new IllegalArgumentException("bean cannot be null");
        }
        try {
            Field field = this.getField();
            return field.get(bean);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("Could not retrieve property '" + this.getName() + "' from bean: " + bean, e);
        }
    }

    @Override
    public Set<Annotation> getAnnotations() {
        Annotation[] annotations = this.getField().getAnnotations();
        return new HashSet<Annotation>(Arrays.asList(annotations));
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return ReflectionUtils.getAnnotation(this.getField(), annotationClass);
    }

    @Override
    public int getTypeArgumentCount() {
        return ReflectionUtils.getTypeParameterCount(this.getGenericType());
    }

    @Override
    public Class<?> getTypeArgument(int i) throws IndexOutOfBoundsException {
        return ReflectionUtils.getTypeParameter(this.getField(), i);
    }

    @Override
    public Class<?> getBaseType() {
        if (this._baseType.isArray()) {
            return this._baseType.getComponentType();
        }
        return this._baseType;
    }

    @Override
    public boolean isArray() {
        return this._baseType.isArray();
    }

    @Override
    public Class<?> getType() {
        return this._baseType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPropertyDescriptor other = (AbstractPropertyDescriptor)obj;
        return !(this._name == null ? other._name != null : !this._name.equals(other._name));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[field=" + this._name + ",baseType=" + this._baseType + "]";
    }

    @Override
    public int compareTo(PropertyDescriptor o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        int result = this.getName().compareTo(o.getName());
        if (result == 0) {
            result = this.getComponentDescriptor().compareTo(o.getComponentDescriptor());
        }
        if (result == 0) {
            result = this.getType().hashCode() - o.getType().hashCode();
        }
        return result;
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor() {
        return this._componentDescriptor;
    }
}

