/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.beans.api.NoAnalyzerResultReducer;
import org.eobjects.analyzer.descriptors.AbstractHasAnalyzerResultBeanDescriptor;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorException;
import org.eobjects.analyzer.result.AnalyzerResultReducer;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.StringUtils;

final class AnnotationBasedAnalyzerBeanDescriptor<A extends Analyzer<?>>
extends AbstractHasAnalyzerResultBeanDescriptor<A>
implements AnalyzerBeanDescriptor<A> {
    private static final long serialVersionUID = 1L;
    private final String _displayName;

    protected AnnotationBasedAnalyzerBeanDescriptor(Class<A> analyzerClass) throws DescriptorException {
        super(analyzerClass, true);
        AnalyzerBean analyzerAnnotation = ReflectionUtils.getAnnotation(analyzerClass, AnalyzerBean.class);
        if (analyzerAnnotation == null) {
            throw new DescriptorException(analyzerClass + " doesn't implement the AnalyzerBean annotation");
        }
        String displayName = analyzerAnnotation.value();
        if (StringUtils.isNullOrEmpty(displayName)) {
            displayName = ReflectionUtils.explodeCamelCase(analyzerClass.getSimpleName(), false);
        }
        this._displayName = displayName.trim();
        this.visitClass();
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public Class<? extends AnalyzerResultReducer<?>> getResultReducerClass() {
        Distributed distributedAnalyzer = this.getAnnotation(Distributed.class);
        if (distributedAnalyzer != null) {
            if (!distributedAnalyzer.value()) {
                return super.getResultReducerClass();
            }
            Class reducer = distributedAnalyzer.reducer();
            if (reducer != null && reducer != NoAnalyzerResultReducer.class) {
                return reducer;
            }
        }
        return super.getResultReducerClass();
    }

    @Override
    public boolean isDistributable() {
        return this.getResultReducerClass() != null;
    }
}

