/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.util.Collections;
import java.util.Set;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.descriptors.AbstractHasAnalyzerResultBeanDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorException;
import org.eobjects.analyzer.descriptors.ExplorerBeanDescriptor;
import org.eobjects.analyzer.result.AnalyzerResultReducer;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.StringUtils;

final class AnnotationBasedExplorerBeanDescriptor<E extends Explorer<?>>
extends AbstractHasAnalyzerResultBeanDescriptor<E>
implements ExplorerBeanDescriptor<E> {
    private static final long serialVersionUID = 1L;
    private final String _displayName;

    protected AnnotationBasedExplorerBeanDescriptor(Class<E> explorerClass) throws DescriptorException {
        super(explorerClass, false);
        AnalyzerBean analyzerAnnotation = ReflectionUtils.getAnnotation(explorerClass, AnalyzerBean.class);
        if (analyzerAnnotation == null) {
            throw new DescriptorException(explorerClass + " doesn't implement the AnalyzerBean annotation");
        }
        String displayName = analyzerAnnotation.value();
        if (StringUtils.isNullOrEmpty(displayName)) {
            displayName = ReflectionUtils.explodeCamelCase(explorerClass.getSimpleName(), false);
        }
        this._displayName = displayName.trim();
        this.visitClass();
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesForInput() {
        return Collections.emptySet();
    }

    @Override
    public Class<? extends AnalyzerResultReducer<?>> getResultReducerClass() {
        return null;
    }

    @Override
    public boolean isDistributable() {
        return false;
    }
}

