/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.FilterBean;
import org.eobjects.analyzer.beans.api.QueryOptimizedFilter;
import org.eobjects.analyzer.descriptors.AbstractBeanDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorException;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.StringUtils;

final class AnnotationBasedFilterBeanDescriptor<F extends Filter<C>, C extends Enum<C>>
extends AbstractBeanDescriptor<F>
implements FilterBeanDescriptor<F, C> {
    private static final long serialVersionUID = 1L;
    private final String _displayName;

    protected AnnotationBasedFilterBeanDescriptor(Class<F> filterClass) throws DescriptorException {
        super(filterClass, false);
        if (!ReflectionUtils.is(filterClass, Filter.class)) {
            throw new DescriptorException(filterClass + " does not implement " + Filter.class.getName());
        }
        FilterBean filterAnnotation = ReflectionUtils.getAnnotation(filterClass, FilterBean.class);
        if (filterAnnotation == null) {
            throw new DescriptorException(filterClass + " doesn't implement the FilterBean annotation");
        }
        String displayName = filterAnnotation.value();
        if (StringUtils.isNullOrEmpty(displayName)) {
            displayName = ReflectionUtils.explodeCamelCase(filterClass.getSimpleName(), false);
        }
        this._displayName = displayName.trim();
        this.visitClass();
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public Class<C> getOutcomeCategoryEnum() {
        Class<?> typeParameter = ReflectionUtils.getTypeParameter(this.getComponentClass(), Filter.class, 0);
        if (typeParameter == null) {
            throw new IllegalStateException("Could not determine Filter's category enum type");
        }
        return typeParameter;
    }

    @Override
    public EnumSet<C> getOutcomeCategories() {
        Class<C> categoryEnum = this.getOutcomeCategoryEnum();
        return EnumSet.allOf(categoryEnum);
    }

    @Override
    public Set<String> getOutcomeCategoryNames() {
        EnumSet<C> enumSet = this.getOutcomeCategories();
        HashSet<String> result = new HashSet<String>();
        for (Enum category : enumSet) {
            result.add(category.name());
        }
        return result;
    }

    @Override
    public Enum<C> getOutcomeCategoryByName(String categoryName) {
        if (categoryName == null) {
            return null;
        }
        EnumSet<C> categories = this.getOutcomeCategories();
        for (Enum c : categories) {
            if (!c.name().equals(categoryName)) continue;
            return c;
        }
        for (Enum c : categories) {
            String[] aliases;
            Alias aliasAnnotation = ReflectionUtils.getAnnotation(c, Alias.class);
            if (aliasAnnotation == null) continue;
            for (String alias : aliases = aliasAnnotation.value()) {
                if (!categoryName.equals(alias)) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public boolean isQueryOptimizable() {
        return ReflectionUtils.is(this.getComponentClass(), QueryOptimizedFilter.class);
    }

    @Override
    public boolean isDistributable() {
        Distributed annotation = this.getAnnotation(Distributed.class);
        if (annotation != null) {
            return annotation.value();
        }
        return true;
    }
}

