/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.data.DataTypeFamily;
import org.eobjects.analyzer.descriptors.AbstractBeanDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorException;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.StringUtils;

final class AnnotationBasedTransformerBeanDescriptor<T extends Transformer<?>>
extends AbstractBeanDescriptor<T>
implements TransformerBeanDescriptor<T> {
    private static final long serialVersionUID = 1L;
    private final String _displayName;

    protected AnnotationBasedTransformerBeanDescriptor(Class<T> transformerClass) throws DescriptorException {
        super(transformerClass, false);
        if (!ReflectionUtils.is(transformerClass, Transformer.class)) {
            throw new DescriptorException(transformerClass + " does not implement " + Transformer.class.getName());
        }
        TransformerBean transformerAnnotation = ReflectionUtils.getAnnotation(transformerClass, TransformerBean.class);
        if (transformerAnnotation == null) {
            throw new DescriptorException(transformerClass + " doesn't implement the TransformerBean annotation");
        }
        String displayName = transformerAnnotation.value();
        if (StringUtils.isNullOrEmpty(displayName)) {
            displayName = ReflectionUtils.explodeCamelCase(transformerClass.getSimpleName(), false);
        }
        this._displayName = displayName.trim();
        this.visitClass();
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public Class<?> getOutputDataType() {
        Class<?> typeParameter = ReflectionUtils.getTypeParameter(this.getComponentClass(), Transformer.class, 0);
        return typeParameter;
    }

    @Override
    public DataTypeFamily getOutputDataTypeFamily() {
        Class<?> outputDataType = this.getOutputDataType();
        return DataTypeFamily.valueOf(outputDataType);
    }

    @Override
    public boolean isDistributable() {
        Distributed annotation = this.getAnnotation(Distributed.class);
        if (annotation != null) {
            return annotation.value();
        }
        return true;
    }
}

