/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.lang.annotation.Annotation;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.FilterBean;
import org.eobjects.analyzer.beans.api.Renderer;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.beans.api.RenderingFormat;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.util.Predicate;
import org.eobjects.metamodel.util.TruePredicate;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BeanClassVisitor
extends ClassVisitor {
    private static final int API_VERSION = 262144;
    private static final Logger _logger = LoggerFactory.getLogger(BeanClassVisitor.class);
    private final ClassLoader _classLoader;
    private final Predicate<Class<? extends RenderingFormat<?>>> _renderingFormatPredicate;
    private Class<?> _beanClazz;
    private String _name;

    public BeanClassVisitor(ClassLoader classLoader, Predicate<Class<? extends RenderingFormat<?>>> renderingFormatPredicate) {
        super(262144);
        this._classLoader = classLoader;
        this._renderingFormatPredicate = renderingFormatPredicate;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this._name = name;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isAnnotation(desc, RendererBean.class)) {
            if (this._renderingFormatPredicate == null || this._renderingFormatPredicate instanceof TruePredicate) {
                this.initializeClass();
                return null;
            }
            return new AnnotationVisitor(262144){

                public void visit(String name, Object value) {
                    Class<?> renderingFormatClass;
                    Type valueType = (Type)value;
                    String renderingFormatClassName = valueType.getClassName();
                    try {
                        Class<?> cls;
                        renderingFormatClass = cls = Class.forName(renderingFormatClassName, false, BeanClassVisitor.this._classLoader);
                    }
                    catch (Exception e) {
                        if (_logger.isWarnEnabled()) {
                            _logger.warn("Failed to read rendering format of renderer class '" + renderingFormatClassName + "', ignoring: " + BeanClassVisitor.this._name, (Throwable)e);
                        }
                        return;
                    }
                    Boolean proceed = (Boolean)BeanClassVisitor.this._renderingFormatPredicate.eval(renderingFormatClass);
                    if (proceed == null || !proceed.booleanValue()) {
                        _logger.info("Skipping renderer because it's format was not accepted by predicate: {}", (Object)BeanClassVisitor.this._name);
                        return;
                    }
                    BeanClassVisitor.this.initializeClass();
                }
            };
        }
        if (this.isAnnotation(desc, AnalyzerBean.class) || this.isAnnotation(desc, TransformerBean.class) || this.isAnnotation(desc, FilterBean.class)) {
            this.initializeClass();
        }
        return null;
    }

    private boolean isAnnotation(String annotationDesc, Class<? extends Annotation> annotationClass) {
        return annotationDesc.indexOf(annotationClass.getName().replace('.', '/')) != -1;
    }

    private Class<?> initializeClass() {
        block4: {
            if (this._beanClazz == null) {
                String javaName = this._name.replace('/', '.');
                try {
                    this._beanClazz = Class.forName(javaName, true, this._classLoader);
                }
                catch (ClassNotFoundException e) {
                    _logger.error("Could not find class to be loaded: " + javaName, (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    _logger.error("Failed to load class {} because of unsatisfied class dependency: {}", (Object)javaName, (Object)e.getMessage());
                    if (!_logger.isDebugEnabled()) break block4;
                    _logger.debug("Failed to load class: " + javaName, (Throwable)e);
                }
            }
        }
        return this._beanClazz;
    }

    public boolean isAnalyzer() {
        if (this._beanClazz != null) {
            return ReflectionUtils.isAnnotationPresent(this._beanClazz, AnalyzerBean.class) && ReflectionUtils.is(this._beanClazz, Analyzer.class);
        }
        return false;
    }

    public boolean isExplorer() {
        if (this._beanClazz != null) {
            return ReflectionUtils.isAnnotationPresent(this._beanClazz, AnalyzerBean.class) && ReflectionUtils.is(this._beanClazz, Explorer.class);
        }
        return false;
    }

    public boolean isTransformer() {
        if (this._beanClazz != null) {
            return ReflectionUtils.isAnnotationPresent(this._beanClazz, TransformerBean.class) && ReflectionUtils.is(this._beanClazz, Transformer.class);
        }
        return false;
    }

    public boolean isRenderer() {
        if (this._beanClazz != null) {
            return ReflectionUtils.isAnnotationPresent(this._beanClazz, RendererBean.class) && ReflectionUtils.is(this._beanClazz, Renderer.class);
        }
        return false;
    }

    public boolean isFilter() {
        if (this._beanClazz != null) {
            return ReflectionUtils.isAnnotationPresent(this._beanClazz, FilterBean.class) && ReflectionUtils.is(this._beanClazz, Filter.class);
        }
        return false;
    }

    public Class<?> getBeanClass() {
        return this._beanClazz;
    }

    public void visitAttribute(Attribute arg0) {
    }

    public void visitEnd() {
    }

    public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
        return null;
    }

    public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
    }

    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        return null;
    }

    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    public void visitSource(String arg0, String arg1) {
    }
}

