/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.Renderer;
import org.eobjects.analyzer.beans.api.RenderingFormat;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.descriptors.AbstractDescriptorProvider;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.BeanClassVisitor;
import org.eobjects.analyzer.descriptors.Descriptors;
import org.eobjects.analyzer.descriptors.ExplorerBeanDescriptor;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.RendererBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.concurrent.SingleThreadedTaskRunner;
import org.eobjects.analyzer.job.concurrent.TaskListener;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.job.tasks.Task;
import org.eobjects.analyzer.util.ClassLoaderUtils;
import org.eobjects.metamodel.util.ExclusionPredicate;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.Predicate;
import org.eobjects.metamodel.util.Ref;
import org.eobjects.metamodel.util.TruePredicate;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathScanDescriptorProvider
extends AbstractDescriptorProvider {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathScanDescriptorProvider.class);
    private final Map<String, AnalyzerBeanDescriptor<?>> _analyzerBeanDescriptors = new HashMap();
    private final Map<String, FilterBeanDescriptor<?, ?>> _filterBeanDescriptors = new HashMap();
    private final Map<String, TransformerBeanDescriptor<?>> _transformerBeanDescriptors = new HashMap();
    private final Map<String, RendererBeanDescriptor<?>> _rendererBeanDescriptors = new HashMap();
    private final Map<String, ExplorerBeanDescriptor<?>> _explorerBeanDescriptors = new HashMap();
    private final TaskRunner _taskRunner;
    private final Predicate<Class<? extends RenderingFormat<?>>> _renderingFormatPredicate;
    private final AtomicInteger _tasksPending;

    public ClasspathScanDescriptorProvider() {
        this(new SingleThreadedTaskRunner());
    }

    public ClasspathScanDescriptorProvider(TaskRunner taskRunner) {
        this(taskRunner, (Predicate<Class<? extends RenderingFormat<?>>>)new TruePredicate());
    }

    public ClasspathScanDescriptorProvider(TaskRunner taskRunner, Collection<Class<? extends RenderingFormat<?>>> excludedRenderingFormats) {
        this(taskRunner, ClasspathScanDescriptorProvider.createRenderingFormatPredicate(excludedRenderingFormats));
    }

    private static Predicate<Class<? extends RenderingFormat<?>>> createRenderingFormatPredicate(Collection<Class<? extends RenderingFormat<?>>> excludedRenderingFormats) {
        if (excludedRenderingFormats == null || excludedRenderingFormats.isEmpty()) {
            return new TruePredicate();
        }
        return new ExclusionPredicate(excludedRenderingFormats);
    }

    public ClasspathScanDescriptorProvider(TaskRunner taskRunner, Predicate<Class<? extends RenderingFormat<?>>> renderingFormatPredicate) {
        this._taskRunner = taskRunner;
        this._tasksPending = new AtomicInteger(0);
        this._renderingFormatPredicate = renderingFormatPredicate;
    }

    public ClasspathScanDescriptorProvider scanPackage(String packageName, boolean recursive) {
        return this.scanPackage(packageName, recursive, ClassLoaderUtils.getParentClassLoader(), false);
    }

    public ClasspathScanDescriptorProvider scanPackage(String packageName, boolean recursive, ClassLoader classLoader) {
        return this.scanPackage(packageName, recursive, classLoader, true);
    }

    public ClasspathScanDescriptorProvider scanPackage(String packageName, boolean recursive, ClassLoader classLoader, boolean strictClassLoader) {
        return this.scanPackage(packageName, recursive, classLoader, strictClassLoader, null);
    }

    public ClasspathScanDescriptorProvider scanPackage(final String packageName, final boolean recursive, final ClassLoader classLoader, final boolean strictClassLoader, final File[] jarFiles) {
        this._tasksPending.incrementAndGet();
        TaskListener listener = new TaskListener(){

            @Override
            public void onBegin(Task task) {
                logger.info("Scan of '{}' beginning", (Object)packageName);
            }

            @Override
            public void onComplete(Task task) {
                logger.info("Scan of '{}' complete", (Object)packageName);
                ClasspathScanDescriptorProvider.this.taskDone();
            }

            @Override
            public void onError(Task task, Throwable throwable) {
                logger.info("Scan of '{}' failed: {}", (Object)packageName, (Object)throwable.getMessage());
                logger.warn("Exception occurred while scanning and installing package: " + packageName, throwable);
                ClasspathScanDescriptorProvider.this.taskDone();
            }
        };
        Task task = new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                String packagePath = packageName.replace('.', '/');
                if (recursive) {
                    logger.info("Scanning package path '{}' (and subpackages recursively)", (Object)packagePath);
                } else {
                    logger.info("Scanning package path '{}'", (Object)packagePath);
                }
                logger.debug("Using ClassLoader: {}", (Object)classLoader);
                if (jarFiles != null && jarFiles.length > 0) {
                    for (File file : jarFiles) {
                        if (!file.exists()) {
                            logger.debug("Omitting JAR file because it does not exist: {}", (Object)file);
                            continue;
                        }
                        if (file.isDirectory()) {
                            logger.info("Scanning subdirectory of: {}", (Object)file);
                            File packageDirectory = new File(file, packagePath);
                            if (packageDirectory.exists()) {
                                ClasspathScanDescriptorProvider.this.scanDirectory(packageDirectory, recursive, classLoader, strictClassLoader);
                                continue;
                            }
                            logger.debug("Omitting directory because it does not exist: {}", (Object)packageDirectory);
                            continue;
                        }
                        logger.info("Scanning JAR file: {}", (Object)file);
                        JarFile jarFile = new JarFile(file);
                        try {
                            ClasspathScanDescriptorProvider.this.scanJar(jarFile, classLoader, packagePath, recursive, strictClassLoader);
                        }
                        catch (Exception e) {
                            logger.error("Failed to scan package '" + packageName + "' in file: " + file, (Throwable)e);
                        }
                        finally {
                            jarFile.close();
                        }
                    }
                } else {
                    Enumeration<URL> resources = classLoader.getResources(packagePath);
                    int count = 0;
                    while (resources.hasMoreElements()) {
                        URL resource = resources.nextElement();
                        logger.debug("Scanning resource/URL no. {}: {}", (Object)(++count), (Object)resource);
                        try {
                            ClasspathScanDescriptorProvider.this.scanUrl(resource, classLoader, packagePath, recursive, strictClassLoader);
                        }
                        catch (Exception e) {
                            logger.error("Failed to scan package '" + packageName + "' in resource/URL: " + resource, (Throwable)e);
                        }
                    }
                    logger.debug("Scanned resources of {}: {}", (Object)packageName, (Object)count);
                }
            }
        };
        this._taskRunner.run(task, listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanUrl(URL resource, ClassLoader classLoader, String packagePath, boolean recursive, boolean strictClassLoader) throws IOException {
        String file = resource.getFile();
        logger.debug("Resource file string: {}", (Object)file);
        File dir = new File(file.replaceAll("\\%20", " "));
        if (dir.isDirectory()) {
            logger.info("Resource is a directory, scanning for files: {}", (Object)dir.getAbsolutePath());
            this.scanDirectory(dir, recursive, classLoader, strictClassLoader);
        } else {
            URLConnection connection = resource.openConnection();
            if (connection instanceof JarURLConnection) {
                logger.info("Getting JarFile from JarURLConnection: {}", (Object)connection);
                JarFile jarFile = ((JarURLConnection)connection).getJarFile();
                this.scanJar(jarFile, classLoader, packagePath, recursive, strictClassLoader);
            } else {
                ZipFile jarFile = null;
                int separatorIndex = file.indexOf("!/");
                try {
                    String rootEntryPath;
                    if (separatorIndex != -1) {
                        String jarFileUrl = file.substring(0, separatorIndex);
                        rootEntryPath = file.substring(separatorIndex + "!/".length());
                        jarFile = this.getJarFile(jarFileUrl);
                    } else {
                        logger.info("Creating JarFile based on URI (without '!/'): {}", (Object)file);
                        jarFile = new JarFile(file);
                        String jarFileUrl = file;
                        rootEntryPath = "";
                    }
                    if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                        rootEntryPath = rootEntryPath + "/";
                    }
                    this.scanJar((JarFile)jarFile, classLoader, packagePath, recursive, strictClassLoader);
                }
                finally {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
            }
        }
    }

    private JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                URI uri = new URI(jarFileUrl.replaceAll(" ", "\\%20"));
                String jarFileName = uri.getSchemeSpecificPart();
                logger.info("Creating new JarFile based on URI-scheme filename: {}", (Object)jarFileName);
                return new JarFile(jarFileName);
            }
            catch (URISyntaxException ex) {
                String jarFileName = jarFileUrl.substring("file:".length());
                logger.info("Creating new JarFile based on alternative filename: {}", (Object)jarFileName);
                return new JarFile(jarFileName);
            }
        }
        logger.info("Creating new JarFile based on URI (with '!/'): {}", (Object)jarFileUrl);
        return new JarFile(jarFileUrl);
    }

    private boolean isClass(String entryName) {
        return entryName.endsWith(".class");
    }

    protected boolean isClassInPackage(String entryName, String packagePath, boolean recursive) {
        if (!entryName.startsWith(packagePath)) {
            return false;
        }
        if (!this.isClass(entryName)) {
            return false;
        }
        if (recursive) {
            return true;
        }
        String trailingPart = entryName.substring(packagePath.length());
        if (trailingPart.startsWith("/")) {
            trailingPart = trailingPart.substring(1);
        }
        return trailingPart.indexOf(47) == -1;
    }

    private void scanJar(final JarFile jarFile, ClassLoader classLoader, String packagePath, boolean recursive, boolean strictClassLoader) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            final JarEntry entry = entries.nextElement();
            Ref<InputStream> entryInputStream = new Ref<InputStream>(){

                public InputStream get() {
                    try {
                        return jarFile.getInputStream(entry);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to read JAR entry InputStream", e);
                    }
                }
            };
            this.scanEntry(entry, packagePath, recursive, classLoader, strictClassLoader, entryInputStream);
        }
    }

    private void scanEntry(JarEntry entry, String packagePath, boolean recursive, ClassLoader classLoader, boolean strictClassLoader, Ref<InputStream> entryInputStream) throws IOException {
        String entryName = entry.getName();
        if (this.isClassInPackage(entryName, packagePath, recursive)) {
            logger.debug("Scanning JAR class file entry: {}", (Object)entryName);
            InputStream inputStream = (InputStream)entryInputStream.get();
            try {
                this.scanInputStreamOfClassFile(inputStream, classLoader, strictClassLoader);
            }
            catch (RuntimeException e) {
                logger.error("Failed to scan JAR class file entry: " + entryName, (Throwable)e);
            }
        } else if (logger.isInfoEnabled()) {
            if (this.isClass(entryName)) {
                logger.debug("Omitting JAR class file entry: {} (looking for package path: {})", (Object)entryName, (Object)packagePath);
            } else {
                logger.trace("Omitting JAR entry (not a class): {}", (Object)entryName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirectory(File dir, boolean recursive, ClassLoader classLoader, boolean strictClassLoader) {
        File[] subDirectories;
        File[] classFiles;
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory '" + dir + "' does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The file '" + dir + "' is not a directory");
        }
        logger.info("Scanning directory: {}", (Object)dir);
        for (File file : classFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return filename.endsWith(".class");
            }
        })) {
            InputStream inputStream = FileHelper.getInputStream((File)file);
            try {
                this.scanInputStream(inputStream, classLoader, strictClassLoader);
            }
            catch (IOException e) {
                try {
                    logger.error("Could not read file", (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{inputStream});
                    throw throwable;
                }
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                continue;
            }
            FileHelper.safeClose((Object[])new Object[]{inputStream});
        }
        if (recursive && (subDirectories = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null) {
            if (logger.isInfoEnabled() && subDirectories.length > 0) {
                logger.info("Recursively scanning " + subDirectories.length + " subdirectories");
            }
            for (File subDir : subDirectories) {
                this.scanDirectory(subDir, true, classLoader, strictClassLoader);
            }
        }
    }

    @Deprecated
    protected void scanInputStream(InputStream inputStream, ClassLoader classLoader, boolean strictClassLoader) throws IOException {
        this.scanInputStreamOfClassFile(inputStream, classLoader, strictClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanInputStreamOfClassFile(InputStream inputStream, ClassLoader classLoader, boolean strictClassLoader) throws IOException {
        Class<?> beanClass;
        BeanClassVisitor visitor;
        block10: {
            block9: {
                try {
                    ClassReader classReader = new ClassReader(inputStream);
                    visitor = new BeanClassVisitor(classLoader, this._renderingFormatPredicate);
                    classReader.accept((ClassVisitor)visitor, 1);
                    beanClass = visitor.getBeanClass();
                    if (beanClass != null) break block9;
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{inputStream});
                    throw throwable;
                }
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                return;
            }
            if (!strictClassLoader || classLoader == null || beanClass.getClassLoader() == classLoader) break block10;
            logger.warn("Scanned class did not belong to required classloader: " + beanClass + ", ignoring");
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            return;
        }
        if (visitor.isAnalyzer()) {
            Class<?> analyzerClass = beanClass;
            logger.info("Adding analyzer class: {}", beanClass);
            this.addAnalyzerClass(analyzerClass);
        }
        if (visitor.isExplorer()) {
            Class<?> explorerClass = beanClass;
            logger.info("Adding explorer class: {}", beanClass);
            this.addExplorerClass(explorerClass);
        }
        if (visitor.isTransformer()) {
            Class<?> transformerClass = beanClass;
            logger.info("Adding transformer class: {}", beanClass);
            this.addTransformerClass(transformerClass);
        }
        if (visitor.isFilter()) {
            Class<?> filterClass = beanClass;
            logger.info("Adding filter class: {}", beanClass);
            this.addFilterClass(filterClass);
        }
        if (visitor.isRenderer()) {
            Class<?> rendererClass = beanClass;
            logger.info("Adding renderer class: {}", beanClass);
            this.addRendererClass(rendererClass);
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
    }

    public ClasspathScanDescriptorProvider addExplorerClass(Class<? extends Explorer<?>> explorerClass) {
        ExplorerBeanDescriptor<Object> descriptor = this._explorerBeanDescriptors.get(explorerClass.getName());
        if (descriptor == null) {
            try {
                descriptor = Descriptors.ofExplorer(explorerClass);
                this._explorerBeanDescriptors.put(explorerClass.getName(), descriptor);
            }
            catch (Exception e) {
                logger.error("Unexpected error occurred while creating descriptor for: " + explorerClass, (Throwable)e);
            }
        }
        return this;
    }

    public ClasspathScanDescriptorProvider addAnalyzerClass(Class<? extends Analyzer<?>> clazz) {
        AnalyzerBeanDescriptor<Object> descriptor = this._analyzerBeanDescriptors.get(clazz.getName());
        if (descriptor == null) {
            try {
                descriptor = Descriptors.ofAnalyzer(clazz);
                this._analyzerBeanDescriptors.put(clazz.getName(), descriptor);
            }
            catch (Exception e) {
                logger.error("Unexpected error occurred while creating descriptor for: " + clazz, (Throwable)e);
            }
        }
        return this;
    }

    public ClasspathScanDescriptorProvider addTransformerClass(Class<? extends Transformer<?>> clazz) {
        TransformerBeanDescriptor<Object> descriptor = this._transformerBeanDescriptors.get(clazz.getName());
        if (descriptor == null) {
            try {
                descriptor = Descriptors.ofTransformer(clazz);
                this._transformerBeanDescriptors.put(clazz.getName(), descriptor);
            }
            catch (Exception e) {
                logger.error("Unexpected error occurred while creating descriptor for: " + clazz, (Throwable)e);
            }
        }
        return this;
    }

    public ClasspathScanDescriptorProvider addFilterClass(Class<? extends Filter<?>> clazz) {
        FilterBeanDescriptor<?, ?> descriptor = this._filterBeanDescriptors.get(clazz.getName());
        if (descriptor == null) {
            try {
                descriptor = Descriptors.ofFilterUnbound(clazz);
                this._filterBeanDescriptors.put(clazz.getName(), descriptor);
            }
            catch (Exception e) {
                logger.error("Unexpected error occurred while creating descriptor for: " + clazz, (Throwable)e);
            }
        }
        return this;
    }

    public ClasspathScanDescriptorProvider addRendererClass(Class<? extends Renderer<?, ?>> clazz) {
        RendererBeanDescriptor<Object> descriptor = this._rendererBeanDescriptors.get(clazz.getName());
        if (descriptor == null) {
            try {
                descriptor = Descriptors.ofRenderer(clazz);
                this._rendererBeanDescriptors.put(clazz.getName(), descriptor);
            }
            catch (Exception e) {
                logger.error("Unexpected error occurred while creating descriptor for: " + clazz, (Throwable)e);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskDone() {
        int tasks = this._tasksPending.decrementAndGet();
        if (tasks == 0) {
            ClasspathScanDescriptorProvider classpathScanDescriptorProvider = this;
            synchronized (classpathScanDescriptorProvider) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitTasks() {
        if (this._tasksPending.get() == 0) {
            return;
        }
        ClasspathScanDescriptorProvider classpathScanDescriptorProvider = this;
        synchronized (classpathScanDescriptorProvider) {
            while (this._tasksPending.get() != 0) {
                try {
                    logger.info("Scan tasks still pending, waiting");
                    this.wait();
                }
                catch (InterruptedException e) {
                    logger.debug("Interrupted while awaiting task completion", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Collection<FilterBeanDescriptor<?, ?>> getFilterBeanDescriptors() {
        this.awaitTasks();
        return Collections.unmodifiableCollection(this._filterBeanDescriptors.values());
    }

    @Override
    public Collection<AnalyzerBeanDescriptor<?>> getAnalyzerBeanDescriptors() {
        this.awaitTasks();
        return Collections.unmodifiableCollection(this._analyzerBeanDescriptors.values());
    }

    @Override
    public Collection<TransformerBeanDescriptor<?>> getTransformerBeanDescriptors() {
        this.awaitTasks();
        return Collections.unmodifiableCollection(this._transformerBeanDescriptors.values());
    }

    @Override
    public Collection<RendererBeanDescriptor<?>> getRendererBeanDescriptors() {
        this.awaitTasks();
        return Collections.unmodifiableCollection(this._rendererBeanDescriptors.values());
    }

    @Override
    public Collection<ExplorerBeanDescriptor<?>> getExplorerBeanDescriptors() {
        this.awaitTasks();
        return Collections.unmodifiableCollection(this._explorerBeanDescriptors.values());
    }

    public Predicate<Class<? extends RenderingFormat<?>>> getRenderingFormatPredicate() {
        return this._renderingFormatPredicate;
    }
}

