/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.lang.reflect.Field;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Convertable;
import org.eobjects.analyzer.beans.api.Converter;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.data.DataTypeFamily;
import org.eobjects.analyzer.descriptors.AbstractPropertyDescriptor;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorException;
import org.eobjects.analyzer.descriptors.PropertyDescriptor;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.StringUtils;

final class ConfiguredPropertyDescriptorImpl
extends AbstractPropertyDescriptor
implements ConfiguredPropertyDescriptor {
    private static final long serialVersionUID = 1L;

    protected ConfiguredPropertyDescriptorImpl(Field field, ComponentDescriptor<?> componentDescriptor) throws DescriptorException {
        super(field, componentDescriptor);
    }

    @Override
    public String getName() {
        String value;
        Configured configured = this.getAnnotation(Configured.class);
        if (configured != null && !StringUtils.isNullOrEmpty(value = configured.value())) {
            return value.trim();
        }
        return ReflectionUtils.explodeCamelCase(super.getName(), true);
    }

    @Override
    public String getDescription() {
        Description desc = this.getAnnotation(Description.class);
        if (desc == null) {
            return null;
        }
        return desc.value();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + "]";
    }

    @Override
    public boolean isInputColumn() {
        Class<?> baseType = this.getBaseType();
        boolean result = ReflectionUtils.isInputColumn(baseType);
        return result;
    }

    @Override
    public boolean isRequired() {
        Configured configured = this.getAnnotation(Configured.class);
        if (configured == null) {
            return true;
        }
        return configured.required();
    }

    @Override
    public DataTypeFamily getInputColumnDataTypeFamily() {
        if (this.isInputColumn()) {
            int count = this.getTypeArgumentCount();
            if (count == 0) {
                return DataTypeFamily.UNDEFINED;
            }
            Class<?> typeArgument = this.getTypeArgument(0);
            return DataTypeFamily.valueOf(typeArgument);
        }
        return null;
    }

    @Override
    public int compareTo(PropertyDescriptor o) {
        Configured conf2;
        int order2;
        Configured conf1 = this.getAnnotation(Configured.class);
        int order1 = conf1.order();
        int diff = order1 - (order2 = (conf2 = o.getAnnotation(Configured.class)) == null ? Integer.MAX_VALUE : conf2.order());
        if (diff == 0) {
            return super.compareTo(o);
        }
        return diff;
    }

    @Override
    public Class<? extends Converter<?>> getCustomConverter() {
        Convertable convertable = this.getAnnotation(Convertable.class);
        if (convertable != null) {
            return convertable.value();
        }
        return null;
    }

    @Override
    public String[] getAliases() {
        Alias alias = this.getAnnotation(Alias.class);
        if (alias == null) {
            return new String[0];
        }
        return alias.value();
    }
}

