/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.beans.api.NoAnalyzerResultReducer;
import org.eobjects.analyzer.descriptors.MetricDescriptor;
import org.eobjects.analyzer.descriptors.MetricDescriptorImpl;
import org.eobjects.analyzer.descriptors.ResultDescriptor;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.AnalyzerResultReducer;
import org.eobjects.analyzer.result.Metric;
import org.eobjects.analyzer.util.ReflectionUtils;

public class ResultDescriptorImpl
implements ResultDescriptor {
    private static final long serialVersionUID = 1L;
    private final Class<? extends AnalyzerResult> _resultClass;
    private final Set<MetricDescriptor> _metrics;

    public ResultDescriptorImpl(Class<? extends AnalyzerResult> resultClass) {
        this._resultClass = resultClass;
        Method[] metricMethods = ReflectionUtils.getMethods(resultClass, Metric.class);
        this._metrics = new TreeSet<MetricDescriptor>();
        for (Method method : metricMethods) {
            MetricDescriptorImpl metric = new MetricDescriptorImpl(resultClass, method);
            this._metrics.add(metric);
        }
    }

    @Override
    public Class<? extends AnalyzerResult> getResultClass() {
        return this._resultClass;
    }

    @Override
    public MetricDescriptor getResultMetric(String name) {
        if (name == null) {
            return null;
        }
        for (MetricDescriptor metric : this._metrics) {
            if (!name.equals(metric.getName())) continue;
            return metric;
        }
        for (MetricDescriptor metric : this._metrics) {
            if (!name.equalsIgnoreCase(metric.getName())) continue;
            return metric;
        }
        return null;
    }

    @Override
    public Set<MetricDescriptor> getResultMetrics() {
        if (this._metrics == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._metrics);
    }

    @Override
    public Class<? extends AnalyzerResultReducer<?>> getResultReducerClass() {
        Distributed distributedResult = ReflectionUtils.getAnnotation(this.getResultClass(), Distributed.class);
        if (distributedResult != null) {
            if (!distributedResult.value()) {
                return null;
            }
            Class reducer = distributedResult.reducer();
            if (reducer != null && reducer != NoAnalyzerResultReducer.class) {
                return reducer;
            }
        }
        return null;
    }
}

