/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.eobjects.analyzer.beans.api.Close;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.api.Validate;
import org.eobjects.analyzer.descriptors.AbstractDescriptor;
import org.eobjects.analyzer.descriptors.CloseMethodDescriptor;
import org.eobjects.analyzer.descriptors.CloseMethodDescriptorImpl;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptorImpl;
import org.eobjects.analyzer.descriptors.DescriptorException;
import org.eobjects.analyzer.descriptors.InitializeMethodDescriptor;
import org.eobjects.analyzer.descriptors.InitializeMethodDescriptorImpl;
import org.eobjects.analyzer.descriptors.ProvidedPropertyDescriptor;
import org.eobjects.analyzer.descriptors.ProvidedPropertyDescriptorImpl;
import org.eobjects.analyzer.descriptors.ValidateMethodDescriptor;
import org.eobjects.analyzer.descriptors.ValidateMethodDescriptorImpl;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleComponentDescriptor<B>
extends AbstractDescriptor<B>
implements ComponentDescriptor<B> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SimpleComponentDescriptor.class);
    protected final Set<ConfiguredPropertyDescriptor> _configuredProperties = new TreeSet<ConfiguredPropertyDescriptor>();
    protected final Set<ProvidedPropertyDescriptor> _providedProperties = new TreeSet<ProvidedPropertyDescriptor>();
    protected final Set<InitializeMethodDescriptor> _initializeMethods;
    protected final Set<ValidateMethodDescriptor> _validateMethods = new HashSet<ValidateMethodDescriptor>();
    protected final Set<CloseMethodDescriptor> _closeMethods;

    public SimpleComponentDescriptor(Class<B> beanClass) {
        this(beanClass, false);
    }

    public SimpleComponentDescriptor(Class<B> beanClass, boolean initialize) {
        super(beanClass);
        this._initializeMethods = new HashSet<InitializeMethodDescriptor>();
        this._closeMethods = new HashSet<CloseMethodDescriptor>();
        if (initialize) {
            this.visitClass();
        }
    }

    @Override
    public String getDisplayName() {
        return this.getComponentClass().getSimpleName();
    }

    @Override
    public B newInstance() {
        try {
            return this.getComponentClass().newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct new instance of " + this.getComponentClass(), e);
        }
    }

    @Override
    protected void visitClass() {
        block3: {
            super.visitClass();
            if (ReflectionUtils.isCloseable(this.getComponentClass())) {
                try {
                    Method method = this.getComponentClass().getMethod("close", new Class[0]);
                    CloseMethodDescriptorImpl cmd = new CloseMethodDescriptorImpl(method, this);
                    this._closeMethods.add(cmd);
                }
                catch (Exception e) {
                    logger.error("Unexpected exception while getting close() method from Closeable", (Throwable)e);
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    protected void visitField(Field field) {
        boolean isInject = ReflectionUtils.isAnnotationPresent(field, Inject.class);
        boolean isConfigured = ReflectionUtils.isAnnotationPresent(field, Configured.class);
        boolean isProvided = ReflectionUtils.isAnnotationPresent(field, Provided.class);
        if (isConfigured && isProvided) {
            throw new DescriptorException("The field " + field + " is annotated with both @Configured and @Provided, which are mutually exclusive.");
        }
        if (!isConfigured && (isInject || isProvided)) {
            this._providedProperties.add(new ProvidedPropertyDescriptorImpl(field, this));
        } else if (isConfigured) {
            if (!isInject) {
                logger.debug("No @Inject annotation found for @Configured field: {}", (Object)field);
            }
            ConfiguredPropertyDescriptorImpl cpd = new ConfiguredPropertyDescriptorImpl(field, this);
            this._configuredProperties.add(cpd);
        }
    }

    @Override
    protected void visitMethod(Method method) {
        boolean isInitializeAnnotationPresent = ReflectionUtils.isAnnotationPresent(method, Initialize.class);
        boolean isPostConstructAnnotationPresent = ReflectionUtils.isAnnotationPresent(method, PostConstruct.class);
        boolean isInitialize = isInitializeAnnotationPresent || isPostConstructAnnotationPresent;
        boolean isPreDestroyAnnotationPresent = ReflectionUtils.isAnnotationPresent(method, PreDestroy.class);
        boolean isCloseAnnotationPresent = ReflectionUtils.isAnnotationPresent(method, Close.class);
        boolean isClose = isCloseAnnotationPresent || isPreDestroyAnnotationPresent;
        boolean isValidate = ReflectionUtils.isAnnotationPresent(method, Validate.class);
        if (isInitialize) {
            this._initializeMethods.add(new InitializeMethodDescriptorImpl(method, this));
        }
        if (isValidate) {
            this._validateMethods.add(new ValidateMethodDescriptorImpl(method, this));
        }
        if (isClose) {
            this._closeMethods.add(new CloseMethodDescriptorImpl(method, this));
        }
    }

    @Override
    public Set<InitializeMethodDescriptor> getInitializeMethods() {
        return Collections.unmodifiableSet(this._initializeMethods);
    }

    @Override
    public Set<ConfiguredPropertyDescriptor> getConfiguredProperties() {
        return Collections.unmodifiableSet(this._configuredProperties);
    }

    @Override
    public Set<CloseMethodDescriptor> getCloseMethods() {
        return Collections.unmodifiableSet(this._closeMethods);
    }

    @Override
    public Set<ValidateMethodDescriptor> getValidateMethods() {
        return Collections.unmodifiableSet(this._validateMethods);
    }

    @Override
    public Set<ProvidedPropertyDescriptor> getProvidedProperties() {
        return Collections.unmodifiableSet(this._providedProperties);
    }

    @Override
    public Set<ProvidedPropertyDescriptor> getProvidedPropertiesByType(Class<?> cls) {
        HashSet<ProvidedPropertyDescriptor> result = new HashSet<ProvidedPropertyDescriptor>();
        for (ProvidedPropertyDescriptor descriptor : this._providedProperties) {
            if (!ReflectionUtils.is(descriptor.getType(), cls)) continue;
            result.add(descriptor);
        }
        return result;
    }

    @Override
    public ConfiguredPropertyDescriptor getConfiguredProperty(String configuredName) {
        for (ConfiguredPropertyDescriptor configuredDescriptor : this._configuredProperties) {
            if (!configuredName.equals(configuredDescriptor.getName())) continue;
            return configuredDescriptor;
        }
        for (ConfiguredPropertyDescriptor configuredDescriptor : this._configuredProperties) {
            Object[] aliases = configuredDescriptor.getAliases();
            if (!ArrayUtils.contains((Object[])aliases, (Object)configuredName)) continue;
            return configuredDescriptor;
        }
        return null;
    }

    @Override
    public Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesByAnnotation(Class<? extends Annotation> annotationClass) {
        TreeSet<ConfiguredPropertyDescriptor> set = new TreeSet<ConfiguredPropertyDescriptor>();
        for (ConfiguredPropertyDescriptor configuredDescriptor : this._configuredProperties) {
            Annotation annotation = configuredDescriptor.getAnnotation(annotationClass);
            if (annotation == null) continue;
            set.add(configuredDescriptor);
        }
        return set;
    }

    @Override
    public Set<ConfiguredPropertyDescriptor> getConfiguredPropertiesByType(Class<?> type, boolean includeArrays) {
        TreeSet<ConfiguredPropertyDescriptor> set = new TreeSet<ConfiguredPropertyDescriptor>();
        for (ConfiguredPropertyDescriptor configuredDescriptor : this._configuredProperties) {
            Class<?> baseType;
            boolean include = includeArrays ? ReflectionUtils.is(configuredDescriptor.getBaseType(), type) : ((baseType = configuredDescriptor.getType()).isArray() == type.isArray() ? ReflectionUtils.is(baseType, type) : false);
            if (!include) continue;
            set.add(configuredDescriptor);
        }
        return set;
    }

    @Override
    public int compareTo(ComponentDescriptor<?> o) {
        if (o == null) {
            return 1;
        }
        Class<?> otherBeanClass = o.getComponentClass();
        if (otherBeanClass == null) {
            return 1;
        }
        String thisBeanClassName = this.getComponentClass().toString();
        String thatBeanClassName = otherBeanClass.toString();
        return thisBeanClassName.compareTo(thatBeanClassName);
    }
}

