/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.beans.api.Renderer;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.descriptors.AbstractDescriptorProvider;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.Descriptors;
import org.eobjects.analyzer.descriptors.ExplorerBeanDescriptor;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.RendererBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;

public class SimpleDescriptorProvider
extends AbstractDescriptorProvider {
    private List<AnalyzerBeanDescriptor<?>> _analyzerBeanDescriptors = new ArrayList();
    private List<ExplorerBeanDescriptor<?>> _explorerBeanDescriptors = new ArrayList();
    private List<TransformerBeanDescriptor<?>> _transformerBeanDescriptors = new ArrayList();
    private List<RendererBeanDescriptor<?>> _rendererBeanDescriptors = new ArrayList();
    private List<FilterBeanDescriptor<?, ?>> _filterBeanDescriptors = new ArrayList();
    private final boolean _autoDiscover;

    public SimpleDescriptorProvider() {
        this(true);
    }

    public SimpleDescriptorProvider(boolean autoDiscover) {
        this._autoDiscover = autoDiscover;
    }

    @Override
    protected <A extends Analyzer<?>> AnalyzerBeanDescriptor<A> notFoundAnalyzer(Class<A> analyzerClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofAnalyzer(analyzerClass);
    }

    @Override
    protected FilterBeanDescriptor<?, ?> notFoundFilter(Class<?> filterClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofFilterUnbound(filterClass);
    }

    @Override
    protected <R extends Renderer<?, ?>> RendererBeanDescriptor<R> notFoundRenderer(Class<R> rendererClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofRenderer(rendererClass);
    }

    @Override
    protected <A extends Transformer<?>> TransformerBeanDescriptor<A> notFoundTransformer(Class<A> transformerClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofTransformer(transformerClass);
    }

    public void addAnalyzerBeanDescriptor(AnalyzerBeanDescriptor<?> analyzerBeanDescriptor) {
        this._analyzerBeanDescriptors.add(analyzerBeanDescriptor);
    }

    public void addTransformerBeanDescriptor(TransformerBeanDescriptor<?> transformerBeanDescriptor) {
        this._transformerBeanDescriptors.add(transformerBeanDescriptor);
    }

    public void addRendererBeanDescriptor(RendererBeanDescriptor<?> rendererBeanDescriptor) {
        this._rendererBeanDescriptors.add(rendererBeanDescriptor);
    }

    public void addFilterBeanDescriptor(FilterBeanDescriptor<?, ?> descriptor) {
        this._filterBeanDescriptors.add(descriptor);
    }

    public void addExplorerBeanDescriptor(ExplorerBeanDescriptor<?> descriptor) {
        this._explorerBeanDescriptors.add(descriptor);
    }

    public List<AnalyzerBeanDescriptor<?>> getAnalyzerBeanDescriptors() {
        return this._analyzerBeanDescriptors;
    }

    public void setAnalyzerBeanDescriptors(List<AnalyzerBeanDescriptor<?>> descriptors) {
        this._analyzerBeanDescriptors = descriptors;
    }

    public List<TransformerBeanDescriptor<?>> getTransformerBeanDescriptors() {
        return this._transformerBeanDescriptors;
    }

    @Override
    public Collection<ExplorerBeanDescriptor<?>> getExplorerBeanDescriptors() {
        return this._explorerBeanDescriptors;
    }

    @Override
    protected <E extends Explorer<?>> ExplorerBeanDescriptor<E> notFoundExplorer(Class<E> explorerClass) {
        return Descriptors.ofExplorer(explorerClass);
    }

    public void setTransformerBeanDescriptors(List<TransformerBeanDescriptor<?>> transformerBeanDescriptors) {
        this._transformerBeanDescriptors = transformerBeanDescriptors;
    }

    public List<RendererBeanDescriptor<?>> getRendererBeanDescriptors() {
        return this._rendererBeanDescriptors;
    }

    public void setRendererBeanDescriptors(List<RendererBeanDescriptor<?>> rendererBeanDescriptors) {
        this._rendererBeanDescriptors = rendererBeanDescriptors;
    }

    @Override
    public Collection<FilterBeanDescriptor<?, ?>> getFilterBeanDescriptors() {
        return this._filterBeanDescriptors;
    }

    public void setFilterBeanDescriptors(List<FilterBeanDescriptor<?, ?>> filterBeanDescriptors) {
        this._filterBeanDescriptors = filterBeanDescriptors;
    }

    public void setAnalyzerClassNames(Collection<String> classNames) throws ClassNotFoundException {
        for (String className : classNames) {
            Class<?> c = Class.forName(className);
            AnalyzerBeanDescriptor<?> descriptor = this.getAnalyzerBeanDescriptorForClass(c);
            if (descriptor != null && this._analyzerBeanDescriptors.contains(descriptor)) continue;
            this.addAnalyzerBeanDescriptor(Descriptors.ofAnalyzer(c));
        }
    }

    public void setTransformerClassNames(Collection<String> classNames) throws ClassNotFoundException {
        for (String className : classNames) {
            Class<?> c = Class.forName(className);
            TransformerBeanDescriptor<?> descriptor = this.getTransformerBeanDescriptorForClass(c);
            if (descriptor != null && this._transformerBeanDescriptors.contains(descriptor)) continue;
            this.addTransformerBeanDescriptor(Descriptors.ofTransformer(c));
        }
    }

    public void setRendererClassNames(Collection<String> classNames) throws ClassNotFoundException {
        for (String className : classNames) {
            Class<?> c = Class.forName(className);
            RendererBeanDescriptor<?> descriptor = this.getRendererBeanDescriptorForClass(c);
            if (descriptor != null && this._rendererBeanDescriptors.contains(descriptor)) continue;
            this.addRendererBeanDescriptor(Descriptors.ofRenderer(c));
        }
    }

    public void setFilterClassNames(Collection<String> classNames) throws ClassNotFoundException {
        for (String className : classNames) {
            Class<?> c = Class.forName(className);
            FilterBeanDescriptor<?, ?> descriptor = this.getFilterBeanDescriptorForClassUnbounded(c);
            if (descriptor != null && this._filterBeanDescriptors.contains(descriptor)) continue;
            this.addFilterBeanDescriptor(Descriptors.ofFilterUnbound(c));
        }
    }
}

