/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.metamodel.util.BaseObject;

public final class ImmutableAnalysisJob
extends BaseObject
implements AnalysisJob {
    private final Datastore _datastore;
    private final Collection<InputColumn<?>> _sourceColumns;
    private final Collection<TransformerJob> _transformerJobs;
    private final Collection<AnalyzerJob> _analyzerJobs;
    private final Collection<ExplorerJob> _explorerJobs;
    private final Collection<FilterJob> _filterJobs;
    private final Collection<MergedOutcomeJob> _mergedOutcomeJobs;

    public ImmutableAnalysisJob(Datastore datastore, Collection<? extends InputColumn<?>> sourceColumns, Collection<FilterJob> filterJobs, Collection<TransformerJob> transformerJobs, Collection<AnalyzerJob> analyzerJobs, Collection<MergedOutcomeJob> mergedOutcomeJobs, Collection<ExplorerJob> explorerJobs) {
        this._datastore = datastore;
        this._sourceColumns = Collections.unmodifiableList(new ArrayList(sourceColumns));
        this._transformerJobs = Collections.unmodifiableList(new ArrayList<TransformerJob>(transformerJobs));
        this._analyzerJobs = Collections.unmodifiableList(new ArrayList<AnalyzerJob>(analyzerJobs));
        this._filterJobs = Collections.unmodifiableList(new ArrayList<FilterJob>(filterJobs));
        this._mergedOutcomeJobs = Collections.unmodifiableList(new ArrayList<MergedOutcomeJob>(mergedOutcomeJobs));
        this._explorerJobs = Collections.unmodifiableList(new ArrayList<ExplorerJob>(explorerJobs));
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._datastore);
        identifiers.add(this._sourceColumns);
        identifiers.add(this._transformerJobs);
        identifiers.add(this._analyzerJobs);
        identifiers.add(this._filterJobs);
        identifiers.add(this._mergedOutcomeJobs);
    }

    @Override
    public Datastore getDatastore() {
        return this._datastore;
    }

    @Override
    public Collection<ExplorerJob> getExplorerJobs() {
        return this._explorerJobs;
    }

    @Override
    public Collection<InputColumn<?>> getSourceColumns() {
        return this._sourceColumns;
    }

    @Override
    public Collection<TransformerJob> getTransformerJobs() {
        return this._transformerJobs;
    }

    @Override
    public Collection<AnalyzerJob> getAnalyzerJobs() {
        return this._analyzerJobs;
    }

    @Override
    public Collection<FilterJob> getFilterJobs() {
        return this._filterJobs;
    }

    @Override
    public Collection<MergedOutcomeJob> getMergedOutcomeJobs() {
        return this._mergedOutcomeJobs;
    }

    public String toString() {
        return "ImmutableAnalysisJob[sourceColumns=" + this._sourceColumns.size() + ",filterJobs=" + this._filterJobs.size() + ",transformerJobs=" + this._transformerJobs.size() + ",analyzerJobs=" + this._analyzerJobs.size() + ",mergedOutcomeJobs=" + this._mergedOutcomeJobs.size() + "]";
    }
}

