/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.BeanConfiguration;
import org.eobjects.analyzer.job.LazyOutcomeUtils;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.metamodel.util.BaseObject;

public final class ImmutableAnalyzerJob
extends BaseObject
implements AnalyzerJob {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final AnalyzerBeanDescriptor<?> _descriptor;
    private final BeanConfiguration _beanConfiguration;
    private final Outcome _requirement;

    public ImmutableAnalyzerJob(String name, AnalyzerBeanDescriptor<?> descriptor, BeanConfiguration beanConfiguration, Outcome requirement) {
        this._name = name;
        this._descriptor = descriptor;
        this._beanConfiguration = beanConfiguration;
        this._requirement = LazyOutcomeUtils.load(requirement);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public AnalyzerBeanDescriptor<?> getDescriptor() {
        return this._descriptor;
    }

    @Override
    public BeanConfiguration getConfiguration() {
        return this._beanConfiguration;
    }

    @Override
    public InputColumn<?>[] getInput() {
        ArrayList<InputColumn> result = new ArrayList<InputColumn>();
        Set<ConfiguredPropertyDescriptor> propertiesForInput = this._descriptor.getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor propertyDescriptor : propertiesForInput) {
            Object property = this._beanConfiguration.getProperty(propertyDescriptor);
            InputColumn[] inputs = CollectionUtils2.arrayOf(InputColumn.class, property);
            if (inputs == null) continue;
            for (InputColumn inputColumn : inputs) {
                result.add(inputColumn);
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._name);
        identifiers.add(this._beanConfiguration);
        identifiers.add(this._descriptor);
        identifiers.add(this._requirement);
    }

    public String toString() {
        return "ImmutableAnalyzerJob[name=" + this._name + ",analyzer=" + this._descriptor.getDisplayName() + "]";
    }

    @Override
    public Outcome[] getRequirements() {
        if (this._requirement == null) {
            return new Outcome[0];
        }
        return new Outcome[]{this._requirement};
    }
}

