/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.BeanConfiguration;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.ImmutableFilterOutcome;
import org.eobjects.analyzer.job.LazyOutcomeUtils;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.metamodel.util.BaseObject;

public final class ImmutableFilterJob
extends BaseObject
implements FilterJob {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final FilterBeanDescriptor<?, ?> _descriptor;
    private final BeanConfiguration _beanConfiguration;
    private final Outcome _requirement;

    public ImmutableFilterJob(String name, FilterBeanDescriptor<?, ?> descriptor, BeanConfiguration beanConfiguration, Outcome requirement) {
        this._name = name;
        this._descriptor = descriptor;
        this._beanConfiguration = beanConfiguration;
        this._requirement = LazyOutcomeUtils.load(requirement);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public FilterBeanDescriptor<?, ?> getDescriptor() {
        return this._descriptor;
    }

    @Override
    public BeanConfiguration getConfiguration() {
        return this._beanConfiguration;
    }

    @Override
    public InputColumn<?>[] getInput() {
        LinkedList<InputColumn> result = new LinkedList<InputColumn>();
        Set<ConfiguredPropertyDescriptor> propertiesForInput = this._descriptor.getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor propertyDescriptor : propertiesForInput) {
            Object property = this._beanConfiguration.getProperty(propertyDescriptor);
            InputColumn[] inputs = CollectionUtils2.arrayOf(InputColumn.class, property);
            if (inputs == null) continue;
            for (InputColumn inputColumn : inputs) {
                result.add(inputColumn);
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    @Override
    public FilterOutcome[] getOutcomes() {
        EnumSet<?> categories = this._descriptor.getOutcomeCategories();
        FilterOutcome[] outcomes = new FilterOutcome[categories.size()];
        int i = 0;
        for (Enum category : categories) {
            outcomes[i] = new ImmutableFilterOutcome(this, category);
            ++i;
        }
        return outcomes;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._name);
        identifiers.add(this._beanConfiguration);
        identifiers.add(this._descriptor);
        identifiers.add(this._requirement);
    }

    public String toString() {
        return "ImmutableFilterJob[name=" + this._name + ",filter=" + this._descriptor.getDisplayName() + "]";
    }

    @Override
    public Outcome[] getRequirements() {
        if (this._requirement == null) {
            return new Outcome[0];
        }
        return new Outcome[]{this._requirement};
    }
}

