/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.BeanConfiguration;
import org.eobjects.analyzer.job.LazyOutcomeUtils;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.metamodel.util.BaseObject;

public final class ImmutableTransformerJob
extends BaseObject
implements TransformerJob {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final TransformerBeanDescriptor<?> _descriptor;
    private final BeanConfiguration _beanConfiguration;
    private final List<MutableInputColumn<?>> _output;
    private final Outcome _requirement;

    public ImmutableTransformerJob(String name, TransformerBeanDescriptor<?> descriptor, BeanConfiguration beanConfiguration, Collection<MutableInputColumn<?>> output, Outcome requirement) {
        this._name = name;
        this._descriptor = descriptor;
        this._beanConfiguration = beanConfiguration;
        this._output = Collections.unmodifiableList(new ArrayList(output));
        this._requirement = LazyOutcomeUtils.load(requirement);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public TransformerBeanDescriptor<?> getDescriptor() {
        return this._descriptor;
    }

    @Override
    public BeanConfiguration getConfiguration() {
        return this._beanConfiguration;
    }

    @Override
    public InputColumn<?>[] getInput() {
        LinkedList<InputColumn> result = new LinkedList<InputColumn>();
        Set<ConfiguredPropertyDescriptor> propertiesForInput = this._descriptor.getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor propertyDescriptor : propertiesForInput) {
            Object property = this._beanConfiguration.getProperty(propertyDescriptor);
            InputColumn[] inputs = CollectionUtils2.arrayOf(InputColumn.class, property);
            if (inputs == null) continue;
            for (InputColumn inputColumn : inputs) {
                result.add(inputColumn);
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    public MutableInputColumn<?>[] getOutput() {
        return this._output.toArray(new MutableInputColumn[this._output.size()]);
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._name);
        identifiers.add(this._beanConfiguration);
        identifiers.add(this._descriptor);
        identifiers.add(this._output);
        identifiers.add(this._requirement);
    }

    public String toString() {
        return "ImmutableTransformerJob[name=" + this._name + ",transformer=" + this._descriptor.getDisplayName() + "]";
    }

    @Override
    public Outcome[] getRequirements() {
        if (this._requirement == null) {
            return new Outcome[0];
        }
        return new Outcome[]{this._requirement};
    }
}

