/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.BeanConfiguration;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.UnconfiguredConfiguredPropertyException;
import org.eobjects.analyzer.lifecycle.LifeCycleHelper;
import org.eobjects.analyzer.result.renderer.Renderable;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBeanJobBuilder<D extends BeanDescriptor<E>, E, B>
implements Renderable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBeanJobBuilder.class);
    private final D _descriptor;
    private final E _configurableBean;
    private volatile String _name;
    private final AnalysisJobBuilder _analysisJobBuilder;

    public AbstractBeanJobBuilder(AnalysisJobBuilder analysisJobBuilder, D descriptor, Class<?> builderClass) {
        if (analysisJobBuilder == null) {
            throw new IllegalArgumentException("analysisJobBuilder cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        if (builderClass == null) {
            throw new IllegalArgumentException("builderClass cannot be null");
        }
        this._analysisJobBuilder = analysisJobBuilder;
        this._descriptor = descriptor;
        if (!ReflectionUtils.is(this.getClass(), builderClass)) {
            throw new IllegalArgumentException("Builder class does not correspond to actual class of builder");
        }
        this._configurableBean = ReflectionUtils.newInstance(this._descriptor.getComponentClass());
    }

    public final AnalysisJobBuilder getAnalysisJobBuilder() {
        return this._analysisJobBuilder;
    }

    public final D getDescriptor() {
        return this._descriptor;
    }

    public final E getConfigurableBean() {
        return this._configurableBean;
    }

    public void setConfiguredProperties(BeanConfiguration configuration) {
        Set<ConfiguredPropertyDescriptor> properties = this.getDescriptor().getConfiguredProperties();
        for (ConfiguredPropertyDescriptor property : properties) {
            Object value = configuration.getProperty(property);
            this.setConfiguredProperty(property, value);
        }
    }

    public final boolean isConfigured(boolean throwException) throws IllegalStateException, UnconfiguredConfiguredPropertyException {
        for (ConfiguredPropertyDescriptor configuredProperty : this._descriptor.getConfiguredProperties()) {
            if (this.isConfigured(configuredProperty, throwException)) continue;
            if (throwException) {
                throw new UnconfiguredConfiguredPropertyException(this, configuredProperty);
            }
            return false;
        }
        try {
            LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(null, null, false);
            lifeCycleHelper.validate((ComponentDescriptor<?>)this.getDescriptor(), this.getConfigurableBean());
        }
        catch (RuntimeException e) {
            if (throwException) {
                throw e;
            }
            return false;
        }
        return true;
    }

    public String getName() {
        return this._name;
    }

    public B setName(String name) {
        this._name = name;
        return (B)this;
    }

    public boolean isConfigured() {
        return this.isConfigured(false);
    }

    public boolean isConfigured(ConfiguredPropertyDescriptor configuredProperty, boolean throwException) {
        if (configuredProperty.isRequired()) {
            Map<ConfiguredPropertyDescriptor, Object> configuredProperties = this.getConfiguredProperties();
            Object value = configuredProperties.get(configuredProperty);
            if (configuredProperty.isArray() && value != null && Array.getLength(value) == 0) {
                value = null;
            }
            if (value == null) {
                if (throwException) {
                    throw new UnconfiguredConfiguredPropertyException(this, configuredProperty);
                }
                logger.debug("Configured property is not set: " + configuredProperty);
                return false;
            }
        }
        return true;
    }

    public B setConfiguredProperty(String configuredName, Object value) {
        ConfiguredPropertyDescriptor configuredProperty = this._descriptor.getConfiguredProperty(configuredName);
        if (configuredProperty == null) {
            throw new IllegalArgumentException("No such configured property: " + configuredName);
        }
        return this.setConfiguredProperty(configuredProperty, value);
    }

    public B setConfiguredProperty(ConfiguredPropertyDescriptor configuredProperty, Object value) {
        if (configuredProperty == null) {
            throw new IllegalArgumentException("configuredProperty cannot be null");
        }
        if (value != null) {
            boolean correctType = true;
            if (configuredProperty.isArray()) {
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Object valuePart = Array.get(value, i);
                        if (valuePart == null) {
                            logger.warn("Element no. {} in array (size {}) is null! Value passed to {}", new Object[]{i, length, configuredProperty});
                            continue;
                        }
                        if (ReflectionUtils.is(valuePart.getClass(), configuredProperty.getBaseType())) continue;
                        correctType = false;
                    }
                } else if (!ReflectionUtils.is(value.getClass(), configuredProperty.getBaseType())) {
                    correctType = false;
                }
            } else if (!ReflectionUtils.is(value.getClass(), configuredProperty.getBaseType())) {
                correctType = false;
            }
            if (!correctType) {
                throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName() + ", expected: " + configuredProperty.getBaseType().getName());
            }
        }
        configuredProperty.setValue(this._configurableBean, value);
        this.onConfigurationChanged();
        return (B)this;
    }

    public Map<ConfiguredPropertyDescriptor, Object> getConfiguredProperties() {
        HashMap<ConfiguredPropertyDescriptor, Object> map = new HashMap<ConfiguredPropertyDescriptor, Object>();
        Set<ConfiguredPropertyDescriptor> configuredProperties = this.getDescriptor().getConfiguredProperties();
        for (ConfiguredPropertyDescriptor propertyDescriptor : configuredProperties) {
            Object value = this.getConfiguredProperty(propertyDescriptor);
            if (value == null) continue;
            map.put(propertyDescriptor, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public void onConfigurationChanged() {
    }

    public Object getConfiguredProperty(ConfiguredPropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getValue(this.getConfigurableBean());
    }
}

