/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.InputColumnSinkJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSinkJob;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBeanWithInputColumnsBuilder<D extends BeanDescriptor<E>, E, B>
extends AbstractBeanJobBuilder<D, E, B>
implements InputColumnSinkJob,
OutcomeSinkJob {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBeanWithInputColumnsBuilder.class);
    private Outcome _requirement;

    public AbstractBeanWithInputColumnsBuilder(AnalysisJobBuilder analysisJobBuilder, D descriptor, Class<?> builderClass) {
        super(analysisJobBuilder, descriptor, builderClass);
    }

    public void clearInputColumns() {
        Set<ConfiguredPropertyDescriptor> configuredProperties = this.getDescriptor().getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor configuredProperty : configuredProperties) {
            if (configuredProperty.isArray()) {
                this.setConfiguredProperty(configuredProperty, (Object)new InputColumn[0]);
                continue;
            }
            this.setConfiguredProperty(configuredProperty, null);
        }
    }

    public B addInputColumn(InputColumn<?> inputColumn) throws IllegalArgumentException {
        Set<ConfiguredPropertyDescriptor> inputProperties = this.getDescriptor().getConfiguredPropertiesForInput(false);
        if (inputProperties.isEmpty()) {
            inputProperties = this.getDescriptor().getConfiguredPropertiesForInput(true);
        }
        if (inputProperties.size() == 1) {
            ConfiguredPropertyDescriptor propertyDescriptor = (ConfiguredPropertyDescriptor)inputProperties.iterator().next();
            return this.addInputColumn(inputColumn, propertyDescriptor);
        }
        throw new UnsupportedOperationException("There are " + inputProperties.size() + " named input columns in \"" + this.getDescriptor().getDisplayName() + "\", please specify which one to configure");
    }

    public B addInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) {
        Class actualDataType;
        if (propertyDescriptor == null || !propertyDescriptor.isInputColumn()) {
            throw new IllegalArgumentException("Property is not of InputColumn type: " + propertyDescriptor);
        }
        Class<?> expectedDataType = propertyDescriptor.getTypeArgument(0);
        if (expectedDataType != null && expectedDataType != Object.class && !ReflectionUtils.is(actualDataType = inputColumn.getDataType(), expectedDataType, false)) {
            throw new IllegalArgumentException("Unsupported InputColumn type: " + actualDataType + ", expected: " + expectedDataType);
        }
        InputColumn[] inputColumns = this.getConfiguredProperty(propertyDescriptor);
        inputColumns = inputColumns == null ? (propertyDescriptor.isArray() ? new InputColumn[]{inputColumn} : inputColumn) : CollectionUtils2.array(InputColumn.class, inputColumns, new InputColumn[]{inputColumn});
        this.setConfiguredProperty(propertyDescriptor, (Object)inputColumns);
        return (B)this;
    }

    public B addInputColumns(Collection<? extends InputColumn<?>> inputColumns) {
        for (InputColumn<?> inputColumn : inputColumns) {
            this.addInputColumn(inputColumn);
        }
        return (B)this;
    }

    public B addInputColumns(InputColumn<?> ... inputColumns) {
        for (InputColumn<?> inputColumn : inputColumns) {
            this.addInputColumn(inputColumn);
        }
        return (B)this;
    }

    public B removeInputColumn(InputColumn<?> inputColumn) {
        Set<ConfiguredPropertyDescriptor> propertyDescriptors = this.getDescriptor().getConfiguredPropertiesForInput();
        if (propertyDescriptors.size() == 1) {
            ConfiguredPropertyDescriptor propertyDescriptor = propertyDescriptors.iterator().next();
            return this.removeInputColumn(inputColumn, propertyDescriptor);
        }
        throw new UnsupportedOperationException("There are " + propertyDescriptors.size() + " named input columns, please specify which one to configure");
    }

    public B removeInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) {
        Object inputColumns = this.getConfiguredProperty(propertyDescriptor);
        if (inputColumns != null) {
            if (inputColumns == inputColumn) {
                inputColumns = null;
            } else if (inputColumns.getClass().isArray()) {
                inputColumns = CollectionUtils.arrayRemove((Object)inputColumns, inputColumn);
            }
            propertyDescriptor.setValue(this.getConfigurableBean(), inputColumns);
            this.onConfigurationChanged();
        }
        return (B)this;
    }

    public List<InputColumn<?>> getInputColumns() {
        LinkedList<InputColumn> result = new LinkedList<InputColumn>();
        Set<ConfiguredPropertyDescriptor> configuredPropertiesForInput = this.getDescriptor().getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor configuredProperty : configuredPropertiesForInput) {
            Object inputColumns = this.getConfiguredProperty(configuredProperty);
            if (inputColumns == null) continue;
            if (inputColumns.getClass().isArray()) {
                int length = Array.getLength(inputColumns);
                for (int i = 0; i < length; ++i) {
                    InputColumn column = (InputColumn)Array.get(inputColumns, i);
                    if (column == null) {
                        logger.warn("Element no. {} in array (size {}) is null! Value read from {}", new Object[]{i, length, configuredProperty});
                        continue;
                    }
                    result.add(column);
                }
                continue;
            }
            result.add((InputColumn)inputColumns);
        }
        return Collections.unmodifiableList(result);
    }

    public Outcome getRequirement() {
        return this._requirement;
    }

    public void setRequirement(FilterJobBuilder<?, ?> filterJobBuilder, Enum<?> category) {
        EnumSet categories = ((FilterBeanDescriptor)filterJobBuilder.getDescriptor()).getOutcomeCategories();
        if (!categories.contains(category)) {
            throw new IllegalArgumentException("No such category found in available outcomes: " + category);
        }
        this.setRequirement(filterJobBuilder.getOutcome(category));
    }

    public void setRequirement(Outcome requirement) throws IllegalArgumentException {
        if (!this.validateRequirementCandidate(requirement)) {
            throw new IllegalArgumentException("Cyclic dependency detected when setting requirement: " + requirement);
        }
        if (this._requirement != requirement) {
            this._requirement = requirement;
            this.onRequirementChanged();
        }
    }

    public boolean validateRequirementSource(OutcomeSourceJob outcomeSourceJob) {
        if (outcomeSourceJob == null) {
            return true;
        }
        Outcome[] outcomes = outcomeSourceJob.getOutcomes();
        if (outcomes == null || outcomes.length == 0) {
            return true;
        }
        return this.validateRequirementCandidate(outcomes[0]);
    }

    public boolean validateRequirementCandidate(Outcome requirement) {
        if (requirement == null) {
            return true;
        }
        OutcomeSourceJob sourceJob = requirement.getSourceJob();
        if (sourceJob == this) {
            return false;
        }
        if (sourceJob instanceof OutcomeSinkJob) {
            Outcome[] requirements;
            for (Outcome transitiveRequirement : requirements = ((OutcomeSinkJob)((Object)sourceJob)).getRequirements()) {
                boolean transitiveValidation = this.validateRequirementCandidate(transitiveRequirement);
                if (transitiveValidation) continue;
                return false;
            }
        }
        return true;
    }

    public void onRequirementChanged() {
    }

    public void setRequirement(FilterJobBuilder<?, ?> filterJobBuilder, String category) {
        EnumSet categories = ((FilterBeanDescriptor)filterJobBuilder.getDescriptor()).getOutcomeCategories();
        for (Enum c : categories) {
            if (!c.name().equals(category)) continue;
            this.setRequirement(filterJobBuilder.getOutcome(c));
            return;
        }
        throw new IllegalArgumentException("No such category found in available outcomes: " + category);
    }

    @Override
    public Outcome[] getRequirements() {
        if (this._requirement == null) {
            return new Outcome[0];
        }
        return new Outcome[]{this._requirement};
    }

    @Override
    public InputColumn<?>[] getInput() {
        List<InputColumn<?>> inputColumns = this.getInputColumns();
        return inputColumns.toArray(new InputColumn[inputColumns.size()]);
    }
}

