/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.data.DataTypeFamily;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MetaModelInputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorProvider;
import org.eobjects.analyzer.descriptors.ExplorerBeanDescriptor;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.ConfigurableBeanJob;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.IdGenerator;
import org.eobjects.analyzer.job.ImmutableAnalysisJob;
import org.eobjects.analyzer.job.InputColumnSourceJob;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.PrefixedIdGenerator;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AbstractBeanWithInputColumnsBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilderImportHelper;
import org.eobjects.analyzer.job.builder.AnalyzerChangeListener;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.job.builder.ExplorerChangeListener;
import org.eobjects.analyzer.job.builder.ExplorerJobBuilder;
import org.eobjects.analyzer.job.builder.FilterChangeListener;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.LazyFilterOutcome;
import org.eobjects.analyzer.job.builder.MergedOutcomeChangeListener;
import org.eobjects.analyzer.job.builder.MergedOutcomeJobBuilder;
import org.eobjects.analyzer.job.builder.SourceColumnChangeListener;
import org.eobjects.analyzer.job.builder.TransformerChangeListener;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.job.builder.UnconfiguredConfiguredPropertyException;
import org.eobjects.analyzer.util.SchemaNavigator;
import org.eobjects.analyzer.util.SourceColumnFinder;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysisJobBuilder
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisJobBuilder.class);
    private final AnalyzerBeansConfiguration _configuration;
    private final IdGenerator _transformedColumnIdGenerator;
    private Datastore _datastore;
    private DatastoreConnection _datastoreConnection;
    private final List<MetaModelInputColumn> _sourceColumns;
    private final List<FilterJobBuilder<?, ?>> _filterJobBuilders;
    private final List<TransformerJobBuilder<?>> _transformerJobBuilders;
    private final List<AnalyzerJobBuilder<?>> _analyzerJobBuilders;
    private final List<ExplorerJobBuilder<?>> _explorerJobBuilders;
    private final List<MergedOutcomeJobBuilder> _mergedOutcomeJobBuilders;
    private final List<SourceColumnChangeListener> _sourceColumnListeners = new ArrayList<SourceColumnChangeListener>();
    private final List<AnalyzerChangeListener> _analyzerChangeListeners = new ArrayList<AnalyzerChangeListener>();
    private final List<ExplorerChangeListener> _explorerChangeListeners = new ArrayList<ExplorerChangeListener>();
    private final List<TransformerChangeListener> _transformerChangeListeners = new ArrayList<TransformerChangeListener>();
    private final List<FilterChangeListener> _filterChangeListeners = new ArrayList<FilterChangeListener>();
    private final List<MergedOutcomeChangeListener> _mergedOutcomeChangeListeners = new ArrayList<MergedOutcomeChangeListener>();
    private Outcome _defaultRequirement;

    public AnalysisJobBuilder(AnalyzerBeansConfiguration configuration) {
        this._configuration = configuration;
        this._transformedColumnIdGenerator = new PrefixedIdGenerator("");
        this._sourceColumns = new ArrayList<MetaModelInputColumn>();
        this._filterJobBuilders = new ArrayList();
        this._transformerJobBuilders = new ArrayList();
        this._analyzerJobBuilders = new ArrayList();
        this._mergedOutcomeJobBuilders = new ArrayList<MergedOutcomeJobBuilder>();
        this._explorerJobBuilders = new ArrayList();
    }

    private AnalysisJobBuilder(AnalyzerBeansConfiguration configuration, DatastoreConnection dataContextProvider, List<MetaModelInputColumn> sourceColumns, Outcome defaultRequirement, IdGenerator idGenerator, List<TransformerJobBuilder<?>> transformerJobBuilders, List<FilterJobBuilder<?, ?>> filterJobBuilders, List<AnalyzerJobBuilder<?>> analyzerJobBuilders, List<MergedOutcomeJobBuilder> mergedOutcomeJobBuilders, List<ExplorerJobBuilder<?>> explorerJobBuilders) {
        this._configuration = configuration;
        this._datastoreConnection = dataContextProvider;
        this._sourceColumns = sourceColumns;
        this._defaultRequirement = defaultRequirement;
        this._transformedColumnIdGenerator = idGenerator;
        this._filterJobBuilders = filterJobBuilders;
        this._transformerJobBuilders = transformerJobBuilders;
        this._analyzerJobBuilders = analyzerJobBuilders;
        this._mergedOutcomeJobBuilders = mergedOutcomeJobBuilders;
        this._explorerJobBuilders = explorerJobBuilders;
    }

    public AnalysisJobBuilder(AnalyzerBeansConfiguration configuration, AnalysisJob job) {
        this(configuration);
        this.importJob(job);
    }

    public AnalysisJobBuilder setDatastore(String datastoreName) {
        Datastore datastore = this._configuration.getDatastoreCatalog().getDatastore(datastoreName);
        if (datastore == null) {
            throw new IllegalArgumentException("No such datastore: " + datastoreName);
        }
        return this.setDatastore(datastore);
    }

    public Datastore getDatastore() {
        return this._datastore;
    }

    public AnalysisJobBuilder setDatastore(Datastore datastore) {
        this._datastore = datastore;
        DatastoreConnection dataContextProvider = datastore == null ? null : datastore.openConnection();
        return this.setDatastoreConnection(dataContextProvider);
    }

    public AnalysisJobBuilder setDatastoreConnection(DatastoreConnection datastoreConnection) {
        if (this._datastoreConnection != null) {
            this._datastoreConnection.close();
        }
        this._datastoreConnection = datastoreConnection;
        return this;
    }

    @Deprecated
    public DatastoreConnection getDataContextProvider() {
        return this._datastoreConnection;
    }

    public DatastoreConnection getDatastoreConnection() {
        return this._datastoreConnection;
    }

    public AnalyzerBeansConfiguration getConfiguration() {
        return this._configuration;
    }

    public AnalysisJobBuilder addSourceColumn(Column column) {
        MetaModelInputColumn inputColumn = new MetaModelInputColumn(column);
        return this.addSourceColumn(inputColumn);
    }

    public AnalysisJobBuilder addSourceColumn(MetaModelInputColumn inputColumn) {
        if (!this._sourceColumns.contains(inputColumn)) {
            this._sourceColumns.add(inputColumn);
            ArrayList<SourceColumnChangeListener> listeners = new ArrayList<SourceColumnChangeListener>(this._sourceColumnListeners);
            for (SourceColumnChangeListener listener : listeners) {
                listener.onAdd(inputColumn);
            }
        }
        return this;
    }

    public AnalysisJobBuilder addSourceColumns(Collection<Column> columns) {
        for (Column column : columns) {
            this.addSourceColumn(column);
        }
        return this;
    }

    public AnalysisJobBuilder addSourceColumns(Column ... columns) {
        for (Column column : columns) {
            this.addSourceColumn(column);
        }
        return this;
    }

    public AnalysisJobBuilder addSourceColumns(MetaModelInputColumn ... inputColumns) {
        for (MetaModelInputColumn metaModelInputColumn : inputColumns) {
            this.addSourceColumn(metaModelInputColumn);
        }
        return this;
    }

    public AnalysisJobBuilder addSourceColumns(String ... columnNames) {
        if (this._datastoreConnection == null) {
            throw new IllegalStateException("Cannot add source columns by name when no Datastore or DatastoreConnection has been set");
        }
        SchemaNavigator schemaNavigator = this._datastoreConnection.getSchemaNavigator();
        Column[] columns = new Column[columnNames.length];
        for (int i = 0; i < columns.length; ++i) {
            String columnName = columnNames[i];
            Column column = schemaNavigator.convertToColumn(columnName);
            if (column == null) {
                throw new IllegalArgumentException("No such column: " + columnName);
            }
            columns[i] = column;
        }
        return this.addSourceColumns(columns);
    }

    public AnalysisJobBuilder removeSourceColumn(Column column) {
        MetaModelInputColumn inputColumn = new MetaModelInputColumn(column);
        return this.removeSourceColumn(inputColumn);
    }

    public void importJob(AnalysisJob job) {
        AnalysisJobBuilderImportHelper helper = new AnalysisJobBuilderImportHelper(this);
        helper.importJob(job);
    }

    public AnalysisJobBuilder removeSourceColumn(MetaModelInputColumn inputColumn) {
        boolean removed = this._sourceColumns.remove(inputColumn);
        if (removed) {
            ArrayList<SourceColumnChangeListener> listeners = new ArrayList<SourceColumnChangeListener>(this._sourceColumnListeners);
            for (SourceColumnChangeListener listener : listeners) {
                listener.onRemove(inputColumn);
            }
        }
        return this;
    }

    public boolean containsSourceColumn(Column column) {
        for (MetaModelInputColumn sourceColumn : this._sourceColumns) {
            if (!sourceColumn.getPhysicalColumn().equals(column)) continue;
            return true;
        }
        return false;
    }

    public List<MetaModelInputColumn> getSourceColumns() {
        return Collections.unmodifiableList(this._sourceColumns);
    }

    public MergedOutcomeJobBuilder addMergedOutcomeJobBuilder() {
        MergedOutcomeJobBuilder mojb = new MergedOutcomeJobBuilder(this, this._transformedColumnIdGenerator);
        return this.addMergedOutcomeJobBuilder(mojb);
    }

    public MergedOutcomeJobBuilder addMergedOutcomeJobBuilder(MergedOutcomeJobBuilder mojb) {
        this._mergedOutcomeJobBuilders.add(mojb);
        ArrayList<MergedOutcomeChangeListener> listeners = new ArrayList<MergedOutcomeChangeListener>(this._mergedOutcomeChangeListeners);
        for (MergedOutcomeChangeListener listener : listeners) {
            listener.onAdd(mojb);
        }
        return mojb;
    }

    public AnalysisJobBuilder removeMergedOutcomeJobBuilder(MergedOutcomeJobBuilder mojb) {
        boolean removed = this._mergedOutcomeJobBuilders.remove(mojb);
        if (removed) {
            mojb.onRemoved();
        }
        return this;
    }

    public List<MergedOutcomeJobBuilder> getMergedOutcomeJobBuilders() {
        return Collections.unmodifiableList(this._mergedOutcomeJobBuilders);
    }

    public <T extends Transformer<?>> TransformerJobBuilder<T> addTransformer(Class<T> transformerClass) {
        TransformerBeanDescriptor<T> descriptor = this._configuration.getDescriptorProvider().getTransformerBeanDescriptorForClass(transformerClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for: " + transformerClass);
        }
        return this.addTransformer(descriptor);
    }

    public List<TransformerJobBuilder<?>> getTransformerJobBuilders() {
        return Collections.unmodifiableList(this._transformerJobBuilders);
    }

    public <T extends Transformer<?>> TransformerJobBuilder<T> addTransformer(TransformerBeanDescriptor<T> descriptor) {
        TransformerJobBuilder<T> tjb = new TransformerJobBuilder<T>(this, descriptor, this._transformedColumnIdGenerator);
        return this.addTransformer(tjb);
    }

    public <T extends Transformer<?>> TransformerJobBuilder<T> addTransformer(TransformerJobBuilder<T> tjb) {
        if (tjb.getRequirement() == null) {
            tjb.setRequirement(this._defaultRequirement);
        }
        this._transformerJobBuilders.add(tjb);
        ArrayList<TransformerChangeListener> listeners = new ArrayList<TransformerChangeListener>(this._transformerChangeListeners);
        for (TransformerChangeListener listener : listeners) {
            listener.onAdd(tjb);
        }
        return tjb;
    }

    public AnalysisJobBuilder removeTransformer(TransformerJobBuilder<?> tjb) {
        boolean removed = this._transformerJobBuilders.remove(tjb);
        if (removed) {
            tjb.onRemoved();
        }
        return this;
    }

    protected Object addComponent(ComponentJob componentJob) {
        AbstractBeanJobBuilder builder;
        if (componentJob instanceof FilterJob) {
            builder = this.addFilter((FilterBeanDescriptor)componentJob.getDescriptor());
        } else if (componentJob instanceof TransformerJob) {
            builder = this.addTransformer((TransformerBeanDescriptor)componentJob.getDescriptor());
        } else if (componentJob instanceof AnalyzerJob) {
            builder = this.addAnalyzer((AnalyzerBeanDescriptor)componentJob.getDescriptor());
        } else if (componentJob instanceof ExplorerJob) {
            builder = this.addExplorer((ExplorerBeanDescriptor)componentJob.getDescriptor());
        } else {
            if (componentJob instanceof MergedOutcomeJob) {
                MergedOutcomeJobBuilder mergedOutcomeJobBuilder = this.addMergedOutcomeJobBuilder();
                mergedOutcomeJobBuilder.setName(componentJob.getName());
                return mergedOutcomeJobBuilder;
            }
            throw new UnsupportedOperationException("Unknown component job type: " + componentJob);
        }
        builder.setName(componentJob.getName());
        if (componentJob instanceof ConfigurableBeanJob) {
            ConfigurableBeanJob configurableBeanJob = (ConfigurableBeanJob)componentJob;
            builder.setConfiguredProperties(configurableBeanJob.getConfiguration());
        }
        if (componentJob instanceof InputColumnSourceJob) {
            InputColumn<?>[] output = ((InputColumnSourceJob)((Object)componentJob)).getOutput();
            TransformerJobBuilder transformerJobBuilder = (TransformerJobBuilder)builder;
            List<MutableInputColumn<?>> outputColumns = transformerJobBuilder.getOutputColumns();
            assert (output.length == outputColumns.size());
            for (int i = 0; i < output.length; ++i) {
                MutableInputColumn<?> mutableOutputColumn = outputColumns.get(i);
                mutableOutputColumn.setName(output[i].getName());
            }
        }
        return builder;
    }

    public <F extends Filter<C>, C extends Enum<C>> FilterJobBuilder<F, C> addFilter(Class<F> filterClass) {
        FilterBeanDescriptor descriptor = this._configuration.getDescriptorProvider().getFilterBeanDescriptorForClass(filterClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for: " + filterClass);
        }
        return this.addFilter(descriptor);
    }

    public <F extends Filter<C>, C extends Enum<C>> FilterJobBuilder<F, C> addFilter(FilterBeanDescriptor<F, C> descriptor) {
        FilterJobBuilder<F, C> fjb = new FilterJobBuilder<F, C>(this, descriptor);
        return this.addFilter(fjb);
    }

    public <F extends Filter<C>, C extends Enum<C>> FilterJobBuilder<F, C> addFilter(FilterJobBuilder<F, C> fjb) {
        this._filterJobBuilders.add(fjb);
        if (fjb.getRequirement() == null) {
            fjb.setRequirement(this._defaultRequirement);
        }
        ArrayList<FilterChangeListener> listeners = new ArrayList<FilterChangeListener>(this._filterChangeListeners);
        for (FilterChangeListener listener : listeners) {
            listener.onAdd(fjb);
        }
        return fjb;
    }

    public AnalysisJobBuilder removeFilter(FilterJobBuilder<?, ?> filterJobBuilder) {
        boolean removed = this._filterJobBuilders.remove(filterJobBuilder);
        if (removed) {
            FilterOutcome[] outcomes;
            Outcome previousRequirement = filterJobBuilder.getRequirement();
            for (FilterOutcome outcome : outcomes = filterJobBuilder.getOutcomes()) {
                Outcome requirement;
                if (outcome.equals(this._defaultRequirement)) {
                    this.setDefaultRequirement(null);
                }
                for (AnalyzerJobBuilder<?> analyzerJobBuilder : this._analyzerJobBuilders) {
                    requirement = analyzerJobBuilder.getRequirement();
                    if (!outcome.equals(requirement)) continue;
                    analyzerJobBuilder.setRequirement(previousRequirement);
                }
                for (TransformerJobBuilder transformerJobBuilder : this._transformerJobBuilders) {
                    requirement = transformerJobBuilder.getRequirement();
                    if (!outcome.equals(requirement)) continue;
                    transformerJobBuilder.setRequirement(previousRequirement);
                }
                for (FilterJobBuilder filterJobBuilder2 : this._filterJobBuilders) {
                    requirement = filterJobBuilder2.getRequirement();
                    if (!outcome.equals(requirement)) continue;
                    filterJobBuilder2.setRequirement(previousRequirement);
                }
            }
            filterJobBuilder.onRemoved();
        }
        return this;
    }

    public List<AnalyzerJobBuilder<?>> getAnalyzerJobBuilders() {
        return Collections.unmodifiableList(this._analyzerJobBuilders);
    }

    public List<FilterJobBuilder<?, ?>> getFilterJobBuilders() {
        return Collections.unmodifiableList(this._filterJobBuilders);
    }

    public <E extends Explorer<?>> ExplorerJobBuilder<E> addExplorer(ExplorerBeanDescriptor<E> descriptor) {
        ExplorerJobBuilder<E> explorerJobBuilder = new ExplorerJobBuilder<E>(this, descriptor);
        this._explorerJobBuilders.add(explorerJobBuilder);
        ArrayList<ExplorerChangeListener> listeners = new ArrayList<ExplorerChangeListener>(this._explorerChangeListeners);
        for (ExplorerChangeListener listener : listeners) {
            listener.onAdd(explorerJobBuilder);
        }
        return explorerJobBuilder;
    }

    public <E extends Explorer<?>> ExplorerJobBuilder<E> addExplorer(Class<E> explorerClass) {
        ExplorerBeanDescriptor<E> descriptor = this._configuration.getDescriptorProvider().getExplorerBeanDescriptorForClass(explorerClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for: " + explorerClass);
        }
        ExplorerJobBuilder<E> explorerJobBuilder = this.addExplorer(descriptor);
        return explorerJobBuilder;
    }

    public <A extends Analyzer<?>> AnalyzerJobBuilder<A> addAnalyzer(AnalyzerBeanDescriptor<A> descriptor) {
        AnalyzerJobBuilder<A> analyzerJobBuilder = new AnalyzerJobBuilder<A>(this, descriptor);
        return this.addAnalyzer(analyzerJobBuilder);
    }

    public <A extends Analyzer<?>> AnalyzerJobBuilder<A> addAnalyzer(AnalyzerJobBuilder<A> analyzerJobBuilder) {
        this._analyzerJobBuilders.add(analyzerJobBuilder);
        if (analyzerJobBuilder.getRequirement() == null) {
            analyzerJobBuilder.setRequirement(this._defaultRequirement);
        }
        ArrayList<AnalyzerChangeListener> listeners = new ArrayList<AnalyzerChangeListener>(this._analyzerChangeListeners);
        for (AnalyzerChangeListener listener : listeners) {
            listener.onAdd(analyzerJobBuilder);
        }
        return analyzerJobBuilder;
    }

    public <A extends Analyzer<?>> AnalyzerJobBuilder<A> addAnalyzer(Class<A> analyzerClass) {
        DescriptorProvider descriptorProvider = this._configuration.getDescriptorProvider();
        AnalyzerBeanDescriptor<A> descriptor = descriptorProvider.getAnalyzerBeanDescriptorForClass(analyzerClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for: " + analyzerClass);
        }
        return this.addAnalyzer(descriptor);
    }

    public AnalysisJobBuilder removeAnalyzer(AnalyzerJobBuilder<?> ajb) {
        boolean removed = this._analyzerJobBuilders.remove(ajb);
        if (removed) {
            ajb.onRemoved();
        }
        return this;
    }

    public AnalysisJobBuilder removeExplorer(ExplorerJobBuilder<?> ejb) {
        boolean removed = this._explorerJobBuilders.remove(ejb);
        if (removed) {
            ejb.onRemoved();
        }
        return this;
    }

    @Deprecated
    public List<InputColumn<?>> getAvailableInputColumns(DataTypeFamily dataTypeFamily) {
        return this.getAvailableInputColumns(dataTypeFamily, null);
    }

    public List<InputColumn<?>> getAvailableInputColumns(Class<?> dataType) {
        return this.getAvailableInputColumns(null, dataType);
    }

    @Deprecated
    public List<InputColumn<?>> getAvailableInputColumns(DataTypeFamily dataTypeFamily, Class<?> dataType) {
        SourceColumnFinder finder = new SourceColumnFinder();
        finder.addSources(this);
        return finder.findInputColumns(dataTypeFamily, dataType);
    }

    public boolean isConfigured(boolean throwException) throws IllegalStateException, UnconfiguredConfiguredPropertyException {
        boolean exploringAnalyzers;
        if (this._datastoreConnection == null) {
            if (throwException) {
                throw new IllegalStateException("No Datastore or DatastoreConnection set");
            }
            return false;
        }
        boolean bl = exploringAnalyzers = !this._explorerJobBuilders.isEmpty();
        if (!exploringAnalyzers && this._sourceColumns.isEmpty()) {
            if (throwException) {
                throw new IllegalStateException("No source columns in job");
            }
            return false;
        }
        if (this._analyzerJobBuilders.isEmpty() && this._explorerJobBuilders.isEmpty()) {
            if (throwException) {
                throw new IllegalStateException("No Analyzers or Explorers in job");
            }
            return false;
        }
        for (FilterJobBuilder<?, ?> filterJobBuilder : this._filterJobBuilders) {
            if (filterJobBuilder.isConfigured(throwException)) continue;
            return false;
        }
        for (TransformerJobBuilder transformerJobBuilder : this._transformerJobBuilders) {
            if (transformerJobBuilder.isConfigured(throwException)) continue;
            return false;
        }
        for (AnalyzerJobBuilder analyzerJobBuilder : this._analyzerJobBuilders) {
            if (analyzerJobBuilder.isConfigured(throwException)) continue;
            return false;
        }
        return true;
    }

    public boolean isConfigured() {
        return this.isConfigured(false);
    }

    public AnalysisJob toAnalysisJob(boolean validate) throws IllegalStateException {
        if (validate && !this.isConfigured(true)) {
            throw new IllegalStateException("Analysis job is not correctly configured");
        }
        LinkedList<ExplorerJob> explorerJobs = new LinkedList<ExplorerJob>();
        for (ExplorerJobBuilder<?> ejb : this._explorerJobBuilders) {
            try {
                ExplorerJob explorerJob = ejb.toExplorerJob(validate);
                explorerJobs.add(explorerJob);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Could not create explorer job from builder: " + ejb + ", (" + e.getMessage() + ")", e);
            }
        }
        LinkedList<FilterJob> filterJobs = new LinkedList<FilterJob>();
        for (FilterJobBuilder<?, ?> fjb : this._filterJobBuilders) {
            try {
                FilterJob filterJob = fjb.toFilterJob(validate);
                filterJobs.add(filterJob);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Could not create filter job from builder: " + fjb + ", (" + e.getMessage() + ")", e);
            }
        }
        LinkedList<MergedOutcomeJob> mergedOutcomeJobs = new LinkedList<MergedOutcomeJob>();
        for (MergedOutcomeJobBuilder mojb : this._mergedOutcomeJobBuilders) {
            try {
                MergedOutcomeJob mergedOutcomeJob = mojb.toMergedOutcomeJob(validate);
                mergedOutcomeJobs.add(mergedOutcomeJob);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Could not create merged outcome job from builder: " + mojb + ", (" + e.getMessage() + ")", e);
            }
        }
        LinkedList<TransformerJob> transformerJobs = new LinkedList<TransformerJob>();
        for (TransformerJobBuilder<?> tjb : this._transformerJobBuilders) {
            try {
                TransformerJob transformerJob = tjb.toTransformerJob(validate);
                transformerJobs.add(transformerJob);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Could not create transformer job from builder: " + tjb + ", (" + e.getMessage() + ")", e);
            }
        }
        LinkedList<AnalyzerJob> analyzerJobs = new LinkedList<AnalyzerJob>();
        for (AnalyzerJobBuilder<?> ajb : this._analyzerJobBuilders) {
            try {
                AnalyzerJob[] analyzerJob;
                for (AnalyzerJob job : analyzerJob = ajb.toAnalyzerJobs(validate)) {
                    analyzerJobs.add(job);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Could not create analyzer job from builder: " + ajb + ", (" + e.getMessage() + ")", e);
            }
        }
        DatastoreConnection con = this._datastoreConnection;
        Datastore datastore = con.getDatastore();
        return new ImmutableAnalysisJob(datastore, this._sourceColumns, filterJobs, transformerJobs, analyzerJobs, mergedOutcomeJobs, explorerJobs);
    }

    public AnalysisJob toAnalysisJob() throws IllegalStateException {
        return this.toAnalysisJob(true);
    }

    public InputColumn<?> getSourceColumnByName(String name) {
        if (name != null) {
            for (MetaModelInputColumn inputColumn : this._sourceColumns) {
                String qualifiedLabel = inputColumn.getPhysicalColumn().getQualifiedLabel();
                if (!name.equalsIgnoreCase(qualifiedLabel)) continue;
                return inputColumn;
            }
            for (MetaModelInputColumn inputColumn : this._sourceColumns) {
                if (!name.equals(inputColumn.getName())) continue;
                return inputColumn;
            }
            for (MetaModelInputColumn inputColumn : this._sourceColumns) {
                if (!name.equalsIgnoreCase(inputColumn.getName())) continue;
                return inputColumn;
            }
        }
        return null;
    }

    public TransformerJobBuilder<?> getOriginatingTransformer(InputColumn<?> outputColumn) {
        SourceColumnFinder finder = new SourceColumnFinder();
        finder.addSources(this);
        InputColumnSourceJob source = finder.findInputColumnSource(outputColumn);
        if (source instanceof TransformerJobBuilder) {
            return (TransformerJobBuilder)source;
        }
        return null;
    }

    public Table getOriginatingTable(InputColumn<?> inputColumn) {
        SourceColumnFinder finder = new SourceColumnFinder();
        finder.addSources(this);
        return finder.findOriginatingTable(inputColumn);
    }

    public Table getOriginatingTable(AbstractBeanWithInputColumnsBuilder<?, ?, ?> beanJobBuilder) {
        List<InputColumn<?>> inputColumns = beanJobBuilder.getInputColumns();
        if (inputColumns.isEmpty()) {
            return null;
        }
        return this.getOriginatingTable(inputColumns.get(0));
    }

    public List<AbstractBeanWithInputColumnsBuilder<?, ?, ?>> getAvailableUnfilteredBeans(FilterJobBuilder<?, ?> filterJobBuilder) {
        ArrayList result = new ArrayList();
        if (filterJobBuilder.isConfigured()) {
            Table foundTable;
            Table requiredTable = this.getOriginatingTable(filterJobBuilder);
            for (FilterJobBuilder<?, ?> filterJobBuilder2 : this._filterJobBuilders) {
                if (filterJobBuilder2 == filterJobBuilder || filterJobBuilder2.getRequirement() != null) continue;
                foundTable = this.getOriginatingTable(filterJobBuilder2);
                if (requiredTable != null && !requiredTable.equals(foundTable)) continue;
                result.add(filterJobBuilder2);
            }
            for (TransformerJobBuilder transformerJobBuilder : this._transformerJobBuilders) {
                if (transformerJobBuilder.getRequirement() != null) continue;
                foundTable = this.getOriginatingTable(transformerJobBuilder);
                if (requiredTable != null && !requiredTable.equals(foundTable)) continue;
                result.add(transformerJobBuilder);
            }
            for (AnalyzerJobBuilder analyzerJobBuilder : this._analyzerJobBuilders) {
                AnalyzerJobBuilder rpajb;
                if (!(analyzerJobBuilder instanceof AnalyzerJobBuilder) || (rpajb = analyzerJobBuilder).getRequirement() != null) continue;
                Table foundTable2 = this.getOriginatingTable(rpajb);
                if (requiredTable != null && !requiredTable.equals(foundTable2)) continue;
                result.add(rpajb);
            }
        }
        return result;
    }

    public void setDefaultRequirement(FilterJobBuilder<?, ?> filterJobBuilder, Enum<?> category) {
        this.setDefaultRequirement(filterJobBuilder.getOutcome(category));
    }

    public void setDefaultRequirement(Outcome defaultRequirement) {
        this._defaultRequirement = defaultRequirement;
        if (defaultRequirement != null) {
            FilterJobBuilder<?, ?> sourceFilterJobBuilder;
            if (defaultRequirement instanceof LazyFilterOutcome) {
                sourceFilterJobBuilder = ((LazyFilterOutcome)defaultRequirement).getFilterJobBuilder();
            } else {
                logger.warn("Default requirement is not a LazyFilterOutcome. This might cause self-referring requirements.");
                sourceFilterJobBuilder = null;
            }
            OutcomeSourceJob source = defaultRequirement.getSourceJob();
            SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
            sourceColumnFinder.addSources(this);
            Set<Object> excludedSet = sourceColumnFinder.findAllSourceJobs(source);
            for (AnalyzerJobBuilder<?> analyzerJobBuilder : this._analyzerJobBuilders) {
                AnalyzerJobBuilder<?> analyzerJobBuilder2;
                Outcome requirement;
                if (!(analyzerJobBuilder instanceof AnalyzerJobBuilder) || (requirement = (analyzerJobBuilder2 = analyzerJobBuilder).getRequirement()) != null) continue;
                analyzerJobBuilder2.setRequirement(defaultRequirement);
            }
            for (TransformerJobBuilder transformerJobBuilder : this._transformerJobBuilders) {
                if (transformerJobBuilder.getRequirement() != null || excludedSet.contains(transformerJobBuilder)) continue;
                transformerJobBuilder.setRequirement(defaultRequirement);
            }
            for (FilterJobBuilder filterJobBuilder : this._filterJobBuilders) {
                if (filterJobBuilder == sourceFilterJobBuilder || filterJobBuilder.getRequirement() != null || excludedSet.contains(filterJobBuilder) || !filterJobBuilder.validateRequirementCandidate(defaultRequirement)) continue;
                filterJobBuilder.setRequirement(defaultRequirement);
            }
        }
    }

    public Outcome getDefaultRequirement() {
        return this._defaultRequirement;
    }

    public List<SourceColumnChangeListener> getSourceColumnListeners() {
        return this._sourceColumnListeners;
    }

    public List<AnalyzerChangeListener> getAnalyzerChangeListeners() {
        return this._analyzerChangeListeners;
    }

    public List<MergedOutcomeChangeListener> getMergedOutcomeChangeListeners() {
        return this._mergedOutcomeChangeListeners;
    }

    public List<ExplorerChangeListener> getExplorerChangeListeners() {
        return this._explorerChangeListeners;
    }

    public List<TransformerChangeListener> getTransformerChangeListeners() {
        return this._transformerChangeListeners;
    }

    public List<FilterChangeListener> getFilterChangeListeners() {
        return this._filterChangeListeners;
    }

    public List<Table> getSourceTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        List<MetaModelInputColumn> columns = this.getSourceColumns();
        for (MetaModelInputColumn column : columns) {
            Table table = column.getPhysicalColumn().getTable();
            if (tables.contains(table)) continue;
            tables.add(table);
        }
        return tables;
    }

    public void reset() {
        this.removeAllSourceColumns();
        this.removeAllMergedOutcomes();
        this.removeAllFilters();
        this.removeAllTransformers();
        this.removeAllAnalyzers();
    }

    public void removeAllSourceColumns() {
        ArrayList<MetaModelInputColumn> sourceColumns = new ArrayList<MetaModelInputColumn>(this._sourceColumns);
        for (MetaModelInputColumn inputColumn : sourceColumns) {
            this.removeSourceColumn(inputColumn);
        }
        assert (this._sourceColumns.isEmpty());
    }

    public void removeAllAnalyzers() {
        ArrayList analyzers = new ArrayList(this._analyzerJobBuilders);
        for (AnalyzerJobBuilder analyzerJobBuilder : analyzers) {
            this.removeAnalyzer(analyzerJobBuilder);
        }
        assert (this._analyzerJobBuilders.isEmpty());
    }

    public void removeAllExplorers() {
        ArrayList explorers = new ArrayList(this._explorerJobBuilders);
        for (ExplorerJobBuilder explorerJobBuilder : explorers) {
            this.removeExplorer(explorerJobBuilder);
        }
        assert (this._explorerJobBuilders.isEmpty());
    }

    public void removeAllTransformers() {
        ArrayList transformers = new ArrayList(this._transformerJobBuilders);
        for (TransformerJobBuilder transformerJobBuilder : transformers) {
            this.removeTransformer(transformerJobBuilder);
        }
        assert (this._transformerJobBuilders.isEmpty());
    }

    public void removeAllFilters() {
        ArrayList filters = new ArrayList(this._filterJobBuilders);
        for (FilterJobBuilder filterJobBuilder : filters) {
            this.removeFilter(filterJobBuilder);
        }
        assert (this._filterJobBuilders.isEmpty());
    }

    public void removeAllMergedOutcomes() {
        ArrayList<MergedOutcomeJobBuilder> mojbs = new ArrayList<MergedOutcomeJobBuilder>(this._mergedOutcomeJobBuilders);
        for (MergedOutcomeJobBuilder mergedOutcomeJobBuilder : mojbs) {
            this.removeMergedOutcomeJobBuilder(mergedOutcomeJobBuilder);
        }
        assert (this._mergedOutcomeJobBuilders.isEmpty());
    }

    @Override
    public void close() {
        if (this._datastoreConnection != null) {
            this._datastoreConnection.close();
        }
    }

    public AnalysisJobBuilder withoutListeners() {
        AnalysisJobBuilder clone = new AnalysisJobBuilder(this._configuration, this._datastoreConnection, this._sourceColumns, this._defaultRequirement, this._transformedColumnIdGenerator, this._transformerJobBuilders, this._filterJobBuilders, this._analyzerJobBuilders, this._mergedOutcomeJobBuilders, this._explorerJobBuilders);
        return clone;
    }
}

