/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MetaModelInputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.ConfigurableBeanJob;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.InputColumnSourceJob;
import org.eobjects.analyzer.job.MergeInput;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.builder.AbstractBeanWithInputColumnsBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.MergeInputBuilder;
import org.eobjects.analyzer.job.builder.MergedOutcomeJobBuilder;
import org.eobjects.analyzer.util.SourceColumnFinder;
import org.eobjects.metamodel.schema.Column;

final class AnalysisJobBuilderImportHelper {
    private final AnalysisJobBuilder _builder;

    public AnalysisJobBuilderImportHelper(AnalysisJobBuilder builder) {
        this._builder = builder;
    }

    public void importJob(AnalysisJob job) {
        ComponentJob componentJob;
        this._builder.setDatastore(job.getDatastore());
        Collection<InputColumn<?>> sourceColumns = job.getSourceColumns();
        for (InputColumn<?> inputColumn : sourceColumns) {
            this._builder.addSourceColumn((MetaModelInputColumn)inputColumn);
        }
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(job);
        IdentityHashMap<ComponentJob, Object> componentBuilders = new IdentityHashMap<ComponentJob, Object>();
        this.addComponentBuilders(job.getFilterJobs(), componentBuilders);
        this.addComponentBuilders(job.getMergedOutcomeJobs(), componentBuilders);
        this.addComponentBuilders(job.getExplorerJobs(), componentBuilders);
        this.addComponentBuilders(job.getTransformerJobs(), componentBuilders);
        this.addComponentBuilders(job.getAnalyzerJobs(), componentBuilders);
        for (Map.Entry entry : componentBuilders.entrySet()) {
            MergeInput[] mergeInputs;
            componentJob = (ComponentJob)entry.getKey();
            if (componentJob instanceof ConfigurableBeanJob) {
                Outcome[] requirements = ((ConfigurableBeanJob)componentJob).getRequirements();
                if (requirements == null || requirements.length <= 0) continue;
                assert (requirements.length == 1);
                AbstractBeanWithInputColumnsBuilder builder = (AbstractBeanWithInputColumnsBuilder)entry.getValue();
                Outcome originalRequirement = requirements[0];
                Outcome requirement = this.findImportedRequirement(originalRequirement, componentBuilders);
                builder.setRequirement(requirement);
                continue;
            }
            if (!(componentJob instanceof MergedOutcomeJob)) continue;
            MergedOutcomeJobBuilder builder = (MergedOutcomeJobBuilder)entry.getValue();
            MergedOutcomeJob mergedOutcomeJob = (MergedOutcomeJob)componentJob;
            for (MergeInput mergeInput : mergeInputs = mergedOutcomeJob.getMergeInputs()) {
                InputColumn<?>[] inputColumns;
                Outcome requirement = this.findImportedRequirement(mergeInput.getOutcome(), componentBuilders);
                MergeInputBuilder mergedOutcomeBuilder = builder.addMergedOutcome(requirement);
                for (InputColumn<?> originalInputColumn : inputColumns = mergeInput.getInputColumns()) {
                    InputColumn<?> inputColumn = this.findImportedInputColumn(originalInputColumn, componentBuilders, sourceColumnFinder);
                    mergedOutcomeBuilder.addInputColumn(inputColumn);
                }
            }
        }
        for (Map.Entry entry : componentBuilders.entrySet()) {
            componentJob = (ComponentJob)entry.getKey();
            if (!(componentJob instanceof ConfigurableBeanJob)) continue;
            ConfigurableBeanJob configurableBeanJob = (ConfigurableBeanJob)componentJob;
            Set<ConfiguredPropertyDescriptor> inputColumnProperties = configurableBeanJob.getDescriptor().getConfiguredPropertiesForInput(true);
            AbstractBeanWithInputColumnsBuilder builder = (AbstractBeanWithInputColumnsBuilder)entry.getValue();
            for (ConfiguredPropertyDescriptor inputColumnProperty : inputColumnProperties) {
                Object originalInputColumnValue = configurableBeanJob.getConfiguration().getProperty(inputColumnProperty);
                Object newInputColumnValue = this.findImportedInputColumns(originalInputColumnValue, componentBuilders, sourceColumnFinder);
                builder.setConfiguredProperty(inputColumnProperty, newInputColumnValue);
            }
        }
    }

    private Object findImportedInputColumns(Object originalInputColumnValue, Map<ComponentJob, Object> componentBuilders, SourceColumnFinder sourceColumnFinder) {
        if (originalInputColumnValue == null) {
            return null;
        }
        if (originalInputColumnValue instanceof InputColumn) {
            return this.findImportedInputColumn((InputColumn)originalInputColumnValue, componentBuilders, sourceColumnFinder);
        }
        if (originalInputColumnValue.getClass().isArray()) {
            int length = Array.getLength(originalInputColumnValue);
            InputColumn[] value = new InputColumn[length];
            for (int i = 0; i < value.length; ++i) {
                InputColumn element = (InputColumn)Array.get(originalInputColumnValue, i);
                value[i] = this.findImportedInputColumn(element, componentBuilders, sourceColumnFinder);
            }
            return value;
        }
        throw new UnsupportedOperationException("Unknown input column value type: " + originalInputColumnValue);
    }

    private InputColumn<?> findImportedInputColumn(InputColumn<?> originalInputColumn, Map<ComponentJob, Object> componentBuilders, SourceColumnFinder sourceColumnFinder) {
        Object[] candidates;
        if (originalInputColumn.isPhysicalColumn()) {
            Column physicalColumn = originalInputColumn.getPhysicalColumn();
            return this._builder.getSourceColumnByName(physicalColumn.getQualifiedLabel());
        }
        InputColumnSourceJob originalSourceJob = sourceColumnFinder.findInputColumnSource(originalInputColumn);
        InputColumnSourceJob newSourceJob = (InputColumnSourceJob)componentBuilders.get(originalSourceJob);
        if (newSourceJob == null) {
            throw new IllegalStateException("Could not find builder corresponding to " + originalSourceJob + " in builder map: " + componentBuilders);
        }
        String originalColumnName = originalInputColumn.getName();
        for (InputColumn<?> inputColumn : candidates = newSourceJob.getOutput()) {
            if (!inputColumn.getName().equals(originalColumnName)) continue;
            return inputColumn;
        }
        throw new IllegalStateException("Could not determine a replacement input column for '" + originalColumnName + "' in output column candidate set: " + Arrays.toString(candidates));
    }

    private Outcome findImportedRequirement(Outcome originalRequirement, Map<ComponentJob, Object> componentBuilders) {
        OutcomeSourceJob sourceJob = originalRequirement.getSourceJob();
        Object builder = componentBuilders.get(sourceJob);
        if (builder == null) {
            throw new IllegalStateException("Could not find builder corresponding to " + sourceJob + " in builder map: " + componentBuilders);
        }
        if (builder instanceof MergedOutcomeJobBuilder) {
            return ((MergedOutcomeJobBuilder)builder).getOutcomes()[0];
        }
        if (builder instanceof FilterJobBuilder) {
            FilterOutcome filterOutcome = (FilterOutcome)originalRequirement;
            Enum<?> category = filterOutcome.getCategory();
            return ((FilterJobBuilder)builder).getOutcome(category);
        }
        throw new UnsupportedOperationException("Unsupported outcome builder type: " + builder);
    }

    private void addComponentBuilders(Collection<? extends ComponentJob> componentJobs, Map<ComponentJob, Object> componentBuilders) {
        for (ComponentJob componentJob : componentJobs) {
            Object builder = this._builder.addComponent(componentJob);
            componentBuilders.put(componentJob, builder);
        }
    }
}

