/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.descriptors.ExplorerBeanDescriptor;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.ImmutableBeanConfiguration;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.ExplorerChangeListener;
import org.eobjects.analyzer.job.builder.ImmutableExplorerJob;

public final class ExplorerJobBuilder<A extends Explorer<?>>
extends AbstractBeanJobBuilder<ExplorerBeanDescriptor<A>, A, ExplorerJobBuilder<A>> {
    private final List<ExplorerChangeListener> _localChangeListeners = new ArrayList<ExplorerChangeListener>(0);

    public ExplorerJobBuilder(AnalysisJobBuilder analysisJobBuilder, ExplorerBeanDescriptor<A> descriptor) {
        super(analysisJobBuilder, descriptor, ExplorerJobBuilder.class);
    }

    public ExplorerJob toExplorerJob() throws IllegalStateException {
        return this.toExplorerJob(true);
    }

    public ExplorerJob toExplorerJob(boolean validate) throws IllegalStateException {
        if (validate && !this.isConfigured()) {
            throw new IllegalStateException("Explorer job is not correctly configured");
        }
        return new ImmutableExplorerJob(this.getName(), (ExplorerBeanDescriptor)this.getDescriptor(), new ImmutableBeanConfiguration(this.getConfiguredProperties()));
    }

    public String toString() {
        return "ExplorerJobBuilder[analyzer=" + ((ExplorerBeanDescriptor)this.getDescriptor()).getDisplayName() + "]";
    }

    @Override
    public void onConfigurationChanged() {
        super.onConfigurationChanged();
        List<ExplorerChangeListener> listeners = this.getAllListeners();
        for (ExplorerChangeListener listener : listeners) {
            listener.onConfigurationChanged(this);
        }
    }

    public void addChangeListener(ExplorerChangeListener listener) {
        this._localChangeListeners.add(listener);
    }

    public boolean removeChangeListener(ExplorerChangeListener listener) {
        return this._localChangeListeners.remove(listener);
    }

    protected void onRemoved() {
        List<ExplorerChangeListener> listeners = this.getAllListeners();
        for (ExplorerChangeListener listener : listeners) {
            listener.onRemove(this);
        }
    }

    private List<ExplorerChangeListener> getAllListeners() {
        List<ExplorerChangeListener> globalChangeListeners = this.getAnalysisJobBuilder().getExplorerChangeListeners();
        ArrayList<ExplorerChangeListener> list = new ArrayList<ExplorerChangeListener>(globalChangeListeners.size() + this._localChangeListeners.size());
        list.addAll(globalChangeListeners);
        list.addAll(this._localChangeListeners);
        return list;
    }
}

