/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.ImmutableBeanConfiguration;
import org.eobjects.analyzer.job.ImmutableFilterJob;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.builder.AbstractBeanWithInputColumnsBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.FilterChangeListener;
import org.eobjects.analyzer.job.builder.LazyFilterOutcome;

public final class FilterJobBuilder<F extends Filter<C>, C extends Enum<C>>
extends AbstractBeanWithInputColumnsBuilder<FilterBeanDescriptor<F, C>, F, FilterJobBuilder<F, C>>
implements OutcomeSourceJob {
    private FilterJob _cachedJob;
    private EnumMap<C, FilterOutcome> _outcomes;
    private final List<FilterChangeListener> _localChangeListeners;

    public FilterJobBuilder(AnalysisJobBuilder analysisJobBuilder, FilterBeanDescriptor<F, C> descriptor) {
        super(analysisJobBuilder, descriptor, FilterJobBuilder.class);
        this._outcomes = new EnumMap(descriptor.getOutcomeCategoryEnum());
        EnumSet<C> categories = descriptor.getOutcomeCategories();
        for (Enum category : categories) {
            this._outcomes.put(category, new LazyFilterOutcome(this, category));
        }
        this._localChangeListeners = new ArrayList<FilterChangeListener>(0);
    }

    public FilterJob toFilterJob() {
        return this.toFilterJob(true);
    }

    public FilterJob toFilterJob(boolean validate) {
        if (validate && !this.isConfigured(true)) {
            throw new IllegalStateException("Filter job is not correctly configured");
        }
        if (this._cachedJob == null) {
            this._cachedJob = new ImmutableFilterJob(this.getName(), (FilterBeanDescriptor)this.getDescriptor(), new ImmutableBeanConfiguration(this.getConfiguredProperties()), this.getRequirement());
        } else {
            ImmutableFilterJob newFilterJob = new ImmutableFilterJob(this.getName(), (FilterBeanDescriptor)this.getDescriptor(), new ImmutableBeanConfiguration(this.getConfiguredProperties()), this.getRequirement());
            if (!newFilterJob.equals(this._cachedJob)) {
                this._cachedJob = newFilterJob;
            }
        }
        return this._cachedJob;
    }

    private List<FilterChangeListener> getAllListeners() {
        List<FilterChangeListener> globalChangeListeners = this.getAnalysisJobBuilder().getFilterChangeListeners();
        ArrayList<FilterChangeListener> list = new ArrayList<FilterChangeListener>(globalChangeListeners.size() + this._localChangeListeners.size());
        list.addAll(globalChangeListeners);
        list.addAll(this._localChangeListeners);
        return list;
    }

    public String toString() {
        return "FilterJobBuilder[filter=" + ((FilterBeanDescriptor)this.getDescriptor()).getDisplayName() + ",inputColumns=" + this.getInputColumns() + "]";
    }

    @Override
    public void onConfigurationChanged() {
        super.onConfigurationChanged();
        List<FilterChangeListener> listeners = this.getAllListeners();
        for (FilterChangeListener listener : listeners) {
            listener.onConfigurationChanged(this);
        }
    }

    @Override
    public void onRequirementChanged() {
        super.onRequirementChanged();
        List<FilterChangeListener> listeners = this.getAllListeners();
        for (FilterChangeListener listener : listeners) {
            listener.onRequirementChanged(this);
        }
    }

    public FilterOutcome[] getOutcomes() {
        Collection<FilterOutcome> outcomes = this._outcomes.values();
        return outcomes.toArray(new FilterOutcome[outcomes.size()]);
    }

    public FilterOutcome getOutcome(C category) {
        FilterOutcome outcome = this._outcomes.get(category);
        if (outcome == null) {
            throw new IllegalArgumentException(category + " is not a valid category for " + this);
        }
        return outcome;
    }

    public FilterOutcome getOutcome(Object category) {
        FilterOutcome outcome = this._outcomes.get(category);
        if (outcome == null) {
            throw new IllegalArgumentException(category + " is not a valid category for " + this);
        }
        return outcome;
    }

    protected void onRemoved() {
        List<FilterChangeListener> listeners = this.getAllListeners();
        for (FilterChangeListener listener : listeners) {
            listener.onRemove(this);
        }
    }

    public void addChangeListener(FilterChangeListener listener) {
        this._localChangeListeners.add(listener);
    }

    public boolean removeChangeListener(FilterChangeListener listener) {
        return this._localChangeListeners.remove(listener);
    }
}

