/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.job.ImmutableMergeInput;
import org.eobjects.analyzer.job.MergeInput;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;

public final class MergeInputBuilder {
    private final List<InputColumn<?>> _inputColumns = new ArrayList();
    private final Outcome _outcome;

    public MergeInputBuilder(FilterJobBuilder<?, ?> filterJobBuilder, Enum<?> category) {
        this._outcome = filterJobBuilder.getOutcome(category);
    }

    public Outcome getOutcome() {
        return this._outcome;
    }

    public MergeInputBuilder(Outcome outcome) {
        this._outcome = outcome;
    }

    public MergeInputBuilder addInputColumn(InputColumn<?> inputColumn) {
        this._inputColumns.add(inputColumn);
        return this;
    }

    public MergeInputBuilder removeInputColumn(InputColumn<?> inputColumn) {
        this._inputColumns.remove(inputColumn);
        return this;
    }

    public List<InputColumn<?>> getInputColumns() {
        return Collections.unmodifiableList(this._inputColumns);
    }

    public MergeInput toMergeInput() {
        return new ImmutableMergeInput(this._inputColumns, this._outcome);
    }
}

