/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.data.TransformedInputColumn;
import org.eobjects.analyzer.job.IdGenerator;
import org.eobjects.analyzer.job.ImmutableMergedOutcomeJob;
import org.eobjects.analyzer.job.InputColumnSinkJob;
import org.eobjects.analyzer.job.InputColumnSourceJob;
import org.eobjects.analyzer.job.LazyMergedOutcome;
import org.eobjects.analyzer.job.MergeInput;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSinkJob;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.MergeInputBuilder;
import org.eobjects.analyzer.job.builder.MergedOutcomeChangeListener;

public final class MergedOutcomeJobBuilder
implements InputColumnSourceJob,
InputColumnSinkJob,
OutcomeSourceJob,
OutcomeSinkJob {
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final List<MergeInputBuilder> _mergeInputs = new ArrayList<MergeInputBuilder>();
    private final List<MutableInputColumn<?>> _outputColumns = new ArrayList();
    private final List<MergedOutcomeChangeListener> _localChangeListeners;
    private final IdGenerator _idGenerator;
    private volatile String _name;
    private volatile MergedOutcomeJob _cachedJob;

    public MergedOutcomeJobBuilder(AnalysisJobBuilder analysisJobBuilder, IdGenerator idGenerator) {
        this._analysisJobBuilder = analysisJobBuilder;
        this._idGenerator = idGenerator;
        this._localChangeListeners = new ArrayList<MergedOutcomeChangeListener>(0);
    }

    public MergeInputBuilder addMergedOutcome(FilterJobBuilder<?, ?> fjb, Enum<?> category) {
        MergeInputBuilder mib = new MergeInputBuilder(fjb, category);
        this._mergeInputs.add(mib);
        return mib;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public MergeInputBuilder addMergedOutcome(Outcome outcome) {
        MergeInputBuilder mib = new MergeInputBuilder(outcome);
        this._mergeInputs.add(mib);
        return mib;
    }

    public MergedOutcomeJobBuilder removeMergeInput(MergeInputBuilder mib) {
        this._mergeInputs.remove(mib);
        return this;
    }

    public List<MergeInputBuilder> getMergeInputs() {
        return Collections.unmodifiableList(this._mergeInputs);
    }

    public MergedOutcomeJob toMergedOutcomeJob(boolean validate) {
        if (validate && this._mergeInputs.isEmpty()) {
            throw new IllegalStateException("Merged outcome jobs need at least 2 merged outcomes, none found");
        }
        if (validate && this._mergeInputs.size() == 1) {
            throw new IllegalStateException("Merged outcome jobs need at least 2 merged outcomes, only 1 found");
        }
        ArrayList<MergeInput> mergeInputs = new ArrayList<MergeInput>();
        for (MergeInputBuilder mib : this._mergeInputs) {
            MergeInput mergeInput = mib.toMergeInput();
            mergeInputs.add(mergeInput);
        }
        ImmutableMergedOutcomeJob job = new ImmutableMergedOutcomeJob(this.getName(), mergeInputs, this.getOutputColumns());
        if (this._cachedJob == null) {
            this._cachedJob = job;
        } else if (!this._cachedJob.equals(job)) {
            this._cachedJob = job;
        }
        return this._cachedJob;
    }

    public MergedOutcomeJob toMergedOutcomeJob() throws IllegalStateException {
        return this.toMergedOutcomeJob(true);
    }

    public List<MutableInputColumn<?>> getOutputColumns() {
        for (MergeInputBuilder mib : this._mergeInputs) {
            int i;
            int numOutput;
            List<InputColumn<?>> inputColumns = mib.getInputColumns();
            int numInput = inputColumns.size();
            if (numInput > (numOutput = this._outputColumns.size())) {
                for (i = numOutput; i < numInput; ++i) {
                    InputColumn<?> inputColumn = inputColumns.get(i);
                    String id = "merged-" + this._idGenerator.nextId();
                    TransformedInputColumn outputColumn = new TransformedInputColumn("Merged column " + (i + 1), id);
                    outputColumn.setDataType(inputColumn.getDataType());
                    this._outputColumns.add(outputColumn);
                }
                continue;
            }
            if (numInput >= numOutput) continue;
            for (i = numOutput; i > numInput; --i) {
                this._outputColumns.remove(i - 1);
            }
        }
        return Collections.unmodifiableList(this._outputColumns);
    }

    @Override
    public InputColumn<?>[] getInput() {
        ArrayList result = new ArrayList();
        List<MergeInputBuilder> mergeInputs = this.getMergeInputs();
        for (MergeInputBuilder mib : mergeInputs) {
            List<InputColumn<?>> inputColumns = mib.getInputColumns();
            for (InputColumn<?> inputColumn : inputColumns) {
                if (result.contains(inputColumn)) continue;
                result.add(inputColumn);
            }
        }
        return result.toArray(new InputColumn[0]);
    }

    public MutableInputColumn<?>[] getOutput() {
        return this.getOutputColumns().toArray(new MutableInputColumn[0]);
    }

    @Override
    public Outcome[] getRequirements() {
        ArrayList<Outcome> result = new ArrayList<Outcome>(this._mergeInputs.size());
        for (MergeInputBuilder mergeInputBuilder : this._mergeInputs) {
            result.add(mergeInputBuilder.getOutcome());
        }
        return result.toArray(new Outcome[result.size()]);
    }

    @Override
    public Outcome[] getOutcomes() {
        return new Outcome[]{new LazyMergedOutcome(this)};
    }

    public void addChangeListener(MergedOutcomeChangeListener listener) {
        this._localChangeListeners.add(listener);
    }

    public boolean removeChangeListener(MergedOutcomeChangeListener listener) {
        return this._localChangeListeners.remove(listener);
    }

    protected void onRemoved() {
        List<MergedOutcomeChangeListener> listeners = this.getAllListeners();
        for (MergedOutcomeChangeListener listener : listeners) {
            listener.onRemove(this);
        }
    }

    private List<MergedOutcomeChangeListener> getAllListeners() {
        List<MergedOutcomeChangeListener> globalChangeListeners = this._analysisJobBuilder.getMergedOutcomeChangeListeners();
        ArrayList<MergedOutcomeChangeListener> list = new ArrayList<MergedOutcomeChangeListener>(globalChangeListeners.size() + this._localChangeListeners.size());
        list.addAll(globalChangeListeners);
        list.addAll(this._localChangeListeners);
        return list;
    }
}

