/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.configuration.InjectionManager;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.data.TransformedInputColumn;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.IdGenerator;
import org.eobjects.analyzer.job.ImmutableBeanConfiguration;
import org.eobjects.analyzer.job.ImmutableTransformerJob;
import org.eobjects.analyzer.job.InputColumnSinkJob;
import org.eobjects.analyzer.job.InputColumnSourceJob;
import org.eobjects.analyzer.job.OutcomeSinkJob;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.builder.AbstractBeanWithInputColumnsBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerChangeListener;
import org.eobjects.analyzer.lifecycle.LifeCycleHelper;
import org.eobjects.analyzer.util.StringUtils;

public final class TransformerJobBuilder<T extends Transformer<?>>
extends AbstractBeanWithInputColumnsBuilder<TransformerBeanDescriptor<T>, T, TransformerJobBuilder<T>>
implements InputColumnSourceJob,
InputColumnSinkJob,
OutcomeSinkJob {
    private final String _id;
    private final List<MutableInputColumn<?>> _outputColumns = new ArrayList();
    private final List<String> _automaticOutputColumnNames = new ArrayList<String>();
    private final IdGenerator _idGenerator;
    private final List<TransformerChangeListener> _localChangeListeners;

    public TransformerJobBuilder(AnalysisJobBuilder analysisJobBuilder, TransformerBeanDescriptor<T> descriptor, IdGenerator idGenerator) {
        super(analysisJobBuilder, descriptor, TransformerJobBuilder.class);
        this._id = "trans-" + idGenerator.nextId();
        this._idGenerator = idGenerator;
        this._localChangeListeners = new ArrayList<TransformerChangeListener>(0);
    }

    public List<MutableInputColumn<?>> getOutputColumns() {
        int existingCols;
        if (!this.isConfigured()) {
            return Collections.emptyList();
        }
        Transformer component = (Transformer)this.getConfigurableBean();
        TransformerBeanDescriptor descriptor = (TransformerBeanDescriptor)this.getDescriptor();
        InjectionManager injectionManager = this.getAnalysisJobBuilder().getConfiguration().getInjectionManager(null);
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, null, false);
        ImmutableBeanConfiguration beanConfiguration = new ImmutableBeanConfiguration(this.getConfiguredProperties());
        lifeCycleHelper.assignConfiguredProperties(descriptor, component, beanConfiguration);
        lifeCycleHelper.assignProvidedProperties(descriptor, component);
        lifeCycleHelper.validate(descriptor, component);
        OutputColumns outputColumns = component.getOutputColumns();
        if (outputColumns == null) {
            throw new IllegalStateException("getOutputColumns() returned null on transformer: " + component);
        }
        boolean changed = false;
        int expectedCols = outputColumns.getColumnCount();
        if (expectedCols != (existingCols = this._outputColumns.size())) {
            int i;
            changed = true;
            int colDiff = expectedCols - existingCols;
            if (colDiff > 0) {
                for (i = 0; i < colDiff; ++i) {
                    int nextIndex = this._outputColumns.size();
                    String name = this.getColumnName(outputColumns, nextIndex);
                    String id = this._id + "-" + this._idGenerator.nextId();
                    this._outputColumns.add(new TransformedInputColumn(name, id));
                    this._automaticOutputColumnNames.add(name);
                }
            } else if (colDiff < 0) {
                for (i = 0; i < Math.abs(colDiff); ++i) {
                    this._outputColumns.remove(this._outputColumns.size() - 1);
                    this._automaticOutputColumnNames.remove(this._automaticOutputColumnNames.size() - 1);
                }
            }
            for (i = 0; i < expectedCols; ++i) {
                MutableInputColumn<?> column = this._outputColumns.get(i);
                String previousProposedName = column.getInitialName();
                String newProposedName = outputColumns.getColumnName(i);
                if (newProposedName == null || newProposedName.equals(previousProposedName)) continue;
                column.setName(newProposedName);
            }
        }
        for (int i = 0; i < expectedCols; ++i) {
            String proposedName = this.getColumnName(outputColumns, i);
            Class<?> dataType = outputColumns.getColumnType(i);
            if (dataType == null) {
                dataType = descriptor.getOutputDataType();
            }
            TransformedInputColumn col = (TransformedInputColumn)this._outputColumns.get(i);
            col.setInitialName(proposedName);
            if (dataType != col.getDataType()) {
                col.setDataType(dataType);
                changed = true;
            }
            String automaticName = this._automaticOutputColumnNames.get(i);
            String columnName = col.getName();
            if (!StringUtils.isNullOrEmpty(columnName) && !automaticName.equals(columnName) || proposedName == null) continue;
            col.setName(proposedName);
            this._automaticOutputColumnNames.set(i, proposedName);
        }
        if (changed) {
            this.onOutputChanged();
        }
        return Collections.unmodifiableList(this._outputColumns);
    }

    private String getColumnName(OutputColumns outputColumns, int index) {
        String name = outputColumns.getColumnName(index);
        if (name == null) {
            name = ((TransformerBeanDescriptor)this.getDescriptor()).getDisplayName() + " (" + (index + 1) + ")";
        }
        return name;
    }

    public void onOutputChanged() {
        List<TransformerChangeListener> listeners = this.getAllListeners();
        for (TransformerChangeListener listener : listeners) {
            listener.onOutputChanged(this, this._outputColumns);
        }
    }

    public TransformerJob toTransformerJob() throws IllegalStateException {
        return this.toTransformerJob(true);
    }

    public TransformerJob toTransformerJob(boolean validate) {
        if (validate && !this.isConfigured(true)) {
            throw new IllegalStateException("Transformer job is not correctly configured");
        }
        return new ImmutableTransformerJob(this.getName(), (TransformerBeanDescriptor)this.getDescriptor(), new ImmutableBeanConfiguration(this.getConfiguredProperties()), this.getOutputColumns(), this.getRequirement());
    }

    public String toString() {
        return "TransformerJobBuilder[transformer=" + ((TransformerBeanDescriptor)this.getDescriptor()).getDisplayName() + ",inputColumns=" + this.getInputColumns() + "]";
    }

    private List<TransformerChangeListener> getAllListeners() {
        List<TransformerChangeListener> globalChangeListeners = this.getAnalysisJobBuilder().getTransformerChangeListeners();
        ArrayList<TransformerChangeListener> list = new ArrayList<TransformerChangeListener>(globalChangeListeners.size() + this._localChangeListeners.size());
        list.addAll(globalChangeListeners);
        list.addAll(this._localChangeListeners);
        return list;
    }

    public MutableInputColumn<?> getOutputColumnByName(String name) {
        if (StringUtils.isNullOrEmpty(name)) {
            return null;
        }
        List<MutableInputColumn<?>> outputColumns = this.getOutputColumns();
        for (MutableInputColumn<?> inputColumn : outputColumns) {
            if (!name.equals(inputColumn.getName())) continue;
            return inputColumn;
        }
        return null;
    }

    @Override
    public void onConfigurationChanged() {
        super.onConfigurationChanged();
        if (this.isConfigured()) {
            this.getOutputColumns();
        }
        List<TransformerChangeListener> listeners = this.getAllListeners();
        for (TransformerChangeListener listener : listeners) {
            listener.onConfigurationChanged(this);
        }
    }

    @Override
    public void onRequirementChanged() {
        super.onRequirementChanged();
        List<TransformerChangeListener> listeners = this.getAllListeners();
        for (TransformerChangeListener listener : listeners) {
            listener.onRequirementChanged(this);
        }
    }

    @Override
    public InputColumn<?>[] getInput() {
        return this.getInputColumns().toArray(new InputColumn[0]);
    }

    public MutableInputColumn<?>[] getOutput() {
        return this.getOutputColumns().toArray(new MutableInputColumn[0]);
    }

    protected void onRemoved() {
        List<TransformerChangeListener> listeners = this.getAllListeners();
        for (TransformerChangeListener listener : listeners) {
            listener.onOutputChanged(this, new LinkedList());
            listener.onRemove(this);
        }
    }

    public void addChangeListener(TransformerChangeListener listener) {
        this._localChangeListeners.add(listener);
    }

    public boolean removeChangeListener(TransformerChangeListener listener) {
        return this._localChangeListeners.remove(listener);
    }
}

