/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eobjects.analyzer.job.concurrent.DaemonThreadFactory;
import org.eobjects.analyzer.job.concurrent.TaskListener;
import org.eobjects.analyzer.job.concurrent.TaskRunnable;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiThreadedTaskRunner
implements TaskRunner {
    private static final Logger logger = LoggerFactory.getLogger(MultiThreadedTaskRunner.class);
    private final ThreadFactory _threadFactory;
    private final ExecutorService _executorService;
    private final int _numThreads;
    private final BlockingQueue<Runnable> _workQueue;

    public MultiThreadedTaskRunner() {
        this(30);
    }

    public MultiThreadedTaskRunner(int numThreads) {
        this._numThreads = numThreads;
        ThreadPoolExecutor.CallerRunsPolicy rejectionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        int taskCapacity = Math.max(20, numThreads * 3);
        this._threadFactory = new DaemonThreadFactory();
        this._workQueue = new ArrayBlockingQueue<Runnable>(taskCapacity);
        this._executorService = new ThreadPoolExecutor(numThreads, numThreads, 60L, TimeUnit.SECONDS, this._workQueue, this._threadFactory, rejectionHandler);
    }

    public int getNumThreads() {
        return this._numThreads;
    }

    @Override
    public void run(Task task, TaskListener listener) {
        logger.debug("run({},{})", (Object)task, (Object)listener);
        this.executeInternal(new TaskRunnable(task, listener));
    }

    @Override
    public void run(TaskRunnable taskRunnable) {
        logger.debug("run({})", (Object)taskRunnable);
        this.executeInternal(taskRunnable);
    }

    private void executeInternal(TaskRunnable taskRunnable) {
        try {
            this._executorService.execute(taskRunnable);
        }
        catch (RejectedExecutionException e) {
            logger.error("Unexpected rejected execution!", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        logger.info("shutdown() called, shutting down executor service");
        this._executorService.shutdown();
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    @Override
    public void assistExecution() {
        Runnable task = (Runnable)this._workQueue.poll();
        if (task != null) {
            task.run();
        }
    }
}

