/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.concurrent;

import org.eobjects.analyzer.job.concurrent.TaskListener;
import org.eobjects.analyzer.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TaskRunnable.class);
    private final Task _task;
    private final TaskListener _listener;

    public TaskRunnable(Task task, TaskListener listener) {
        if (task == null && listener == null) {
            throw new IllegalArgumentException("both task and listener cannot be null");
        }
        this._task = task;
        this._listener = listener;
    }

    @Override
    public final void run() {
        if (this._listener == null) {
            try {
                this._task.execute();
            }
            catch (Throwable t) {
                logger.warn("No TaskListener to inform of error!", t);
            }
        } else {
            this._listener.onBegin(this._task);
            try {
                if (this._task != null) {
                    this._task.execute();
                }
                this._listener.onComplete(this._task);
            }
            catch (Throwable t) {
                this._listener.onError(this._task, t);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (this._task != null) {
            sb.append("task=" + this._task);
            if (this._listener != null) {
                sb.append(',');
            }
        }
        if (this._listener != null) {
            sb.append("listener=" + this._listener);
        }
        sb.append(']');
        return sb.toString();
    }

    public final Task getTask() {
        return this._task;
    }

    public final TaskListener getListener() {
        return this._listener;
    }
}

