/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.Collection;
import org.eobjects.analyzer.data.ExpressionBasedInputColumn;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.job.InputColumnSinkJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSinkJob;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;

abstract class AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private final OutcomeSinkJob _outcomeSinkJob;
    private final InputColumnSinkJob _inputColumnSinkJob;

    protected AbstractRowProcessingConsumer(OutcomeSinkJob outcomeSinkJob, InputColumnSinkJob inputColumnSinkJob) {
        this._outcomeSinkJob = outcomeSinkJob;
        this._inputColumnSinkJob = inputColumnSinkJob;
    }

    @Override
    public final boolean satisfiedForConsume(Outcome[] outcomes, InputRow row) {
        return this.satisfiedOutcomesForConsume(outcomes) && this.satisfiedInputsForConsume(row);
    }

    @Override
    public InputColumn<?>[] getOutputColumns() {
        return new InputColumn[0];
    }

    private boolean satisfiedInputsForConsume(InputRow row) {
        boolean isSatisfiedInputColumns = true;
        InputColumn<?>[] requiredInputColumns = this._inputColumnSinkJob.getInput();
        if (requiredInputColumns == null || requiredInputColumns.length == 0) {
            isSatisfiedInputColumns = true;
        } else {
            for (InputColumn<?> inputColumn : requiredInputColumns) {
                if (inputColumn instanceof ExpressionBasedInputColumn || row.containsInputColumn(inputColumn)) continue;
                isSatisfiedInputColumns = false;
                break;
            }
        }
        return isSatisfiedInputColumns;
    }

    private boolean satisfiedOutcomesForConsume(Outcome[] outcomes) {
        boolean isSatisfiedOutcomes = false;
        Outcome[] requirements = this._outcomeSinkJob.getRequirements();
        if (requirements == null || requirements.length == 0) {
            isSatisfiedOutcomes = true;
        } else {
            block0: for (Outcome requiredOutcome : requirements) {
                for (Outcome availableOutcome : outcomes) {
                    if (!availableOutcome.satisfiesRequirement(requiredOutcome)) continue;
                    isSatisfiedOutcomes = true;
                    continue block0;
                }
            }
        }
        return isSatisfiedOutcomes;
    }

    @Override
    public final boolean satisfiedForFlowOrdering(Collection<Outcome> outcomes) {
        Outcome[] requirements = this._outcomeSinkJob.getRequirements();
        if (requirements == null || requirements.length == 0) {
            return true;
        }
        for (Outcome requiredOutcome : requirements) {
            boolean found = false;
            for (Outcome availableOutcome : outcomes) {
                if (!availableOutcome.satisfiesRequirement(requiredOutcome)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

