/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.runner.AnalysisJobMetrics;
import org.eobjects.analyzer.job.runner.AnalyzerMetrics;
import org.eobjects.analyzer.job.runner.AnalyzerMetricsImpl;
import org.eobjects.analyzer.job.runner.ExplorerMetrics;
import org.eobjects.analyzer.job.runner.ExplorerMetricsImpl;
import org.eobjects.analyzer.job.runner.RowProcessingMetrics;
import org.eobjects.analyzer.job.runner.RowProcessingPublisher;
import org.eobjects.analyzer.job.runner.RowProcessingPublishers;
import org.eobjects.metamodel.schema.Table;

final class AnalysisJobMetricsImpl
implements AnalysisJobMetrics {
    private final AnalysisJob _job;
    private final RowProcessingPublishers _publishers;

    public AnalysisJobMetricsImpl(AnalysisJob job, RowProcessingPublishers publishers) {
        this._job = job;
        this._publishers = publishers;
    }

    @Override
    public AnalysisJob getAnalysisJob() {
        return this._job;
    }

    @Override
    public ExplorerMetrics getExplorerMetrics(ExplorerJob explorerJob) {
        return new ExplorerMetricsImpl(this, explorerJob);
    }

    @Override
    public AnalyzerMetrics getAnalyzerMetrics(AnalyzerJob analyzerJob) {
        Table table = this.getRowProcessingTable(analyzerJob);
        RowProcessingMetrics rowProcessingMetrics = this.getRowProcessingMetrics(table);
        return new AnalyzerMetricsImpl(rowProcessingMetrics, analyzerJob);
    }

    @Override
    public Table[] getRowProcessingTables() {
        return this._publishers.getTables();
    }

    @Override
    public RowProcessingMetrics getRowProcessingMetrics(Table table) {
        RowProcessingPublisher publisher = this._publishers.getRowProcessingPublisher(table);
        if (publisher == null) {
            return null;
        }
        return publisher.getRowProcessingMetrics();
    }

    @Override
    public Table getRowProcessingTable(AnalyzerJob analyzerJob) {
        Table[] tables = this._publishers.getTables(analyzerJob);
        if (tables == null || tables.length == 0) {
            return null;
        }
        return tables[0];
    }
}

