/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.concurrent.LinkedBlockingQueue;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.AnalysisResultFuture;
import org.eobjects.analyzer.job.runner.AnalysisRunner;
import org.eobjects.analyzer.job.runner.AnalysisRunnerJobDelegate;
import org.eobjects.analyzer.job.runner.CompositeAnalysisListener;
import org.eobjects.analyzer.job.runner.DebugLoggingAnalysisListener;
import org.eobjects.analyzer.job.runner.ErrorAwareAnalysisListener;
import org.eobjects.analyzer.job.runner.ErrorAwareTaskRunnerWrapper;
import org.eobjects.analyzer.job.runner.InfoLoggingAnalysisListener;
import org.eobjects.analyzer.job.runner.JobAndResult;

public class AnalysisRunnerImpl
implements AnalysisRunner {
    private final AnalyzerBeansConfiguration _configuration;
    private final AnalysisListener[] _sharedAnalysisListeners;

    public AnalysisRunnerImpl(AnalyzerBeansConfiguration configuration) {
        this(configuration, new AnalysisListener[0]);
    }

    public AnalysisRunnerImpl(AnalyzerBeansConfiguration configuration, AnalysisListener ... sharedAnalysisListeners) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this._configuration = configuration;
        this._sharedAnalysisListeners = sharedAnalysisListeners;
    }

    @Override
    public AnalysisResultFuture run(AnalysisJob job) {
        LinkedBlockingQueue<JobAndResult> resultQueue = new LinkedBlockingQueue<JobAndResult>();
        ErrorAwareAnalysisListener errorListener = new ErrorAwareAnalysisListener();
        CompositeAnalysisListener analysisListener = new CompositeAnalysisListener(errorListener, this._sharedAnalysisListeners);
        if (DebugLoggingAnalysisListener.isEnabled()) {
            analysisListener.addDelegate(new DebugLoggingAnalysisListener());
        } else if (InfoLoggingAnalysisListener.isEnabled()) {
            analysisListener.addDelegate(new InfoLoggingAnalysisListener());
        }
        ErrorAwareTaskRunnerWrapper taskRunner = new ErrorAwareTaskRunnerWrapper(errorListener, this._configuration.getTaskRunner());
        boolean includedNonDistributed = this.isNonDistributedTasksIncluded();
        AnalysisRunnerJobDelegate delegate = new AnalysisRunnerJobDelegate(job, this._configuration, taskRunner, analysisListener, resultQueue, errorListener, includedNonDistributed);
        return delegate.run();
    }

    protected boolean isNonDistributedTasksIncluded() {
        return true;
    }
}

