/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.configuration.InjectionManager;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.ExplorerBeanDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ConfigurableBeanJob;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.MergeInput;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.concurrent.ForkTaskListener;
import org.eobjects.analyzer.job.concurrent.JobCompletionTaskListener;
import org.eobjects.analyzer.job.concurrent.JoinTaskListener;
import org.eobjects.analyzer.job.concurrent.RunNextTaskTaskListener;
import org.eobjects.analyzer.job.concurrent.TaskRunnable;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.job.runner.AnalysisJobMetrics;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.AnalysisResultFuture;
import org.eobjects.analyzer.job.runner.AnalysisResultFutureImpl;
import org.eobjects.analyzer.job.runner.ErrorAware;
import org.eobjects.analyzer.job.runner.ExplorerMetrics;
import org.eobjects.analyzer.job.runner.JobAndResult;
import org.eobjects.analyzer.job.runner.ReferenceDataActivationManager;
import org.eobjects.analyzer.job.runner.RowProcessingPublisher;
import org.eobjects.analyzer.job.runner.RowProcessingPublishers;
import org.eobjects.analyzer.job.tasks.CloseReferenceDataTaskListener;
import org.eobjects.analyzer.job.tasks.CloseResourcesTaskListener;
import org.eobjects.analyzer.job.tasks.CloseTaskListener;
import org.eobjects.analyzer.job.tasks.CollectResultsTask;
import org.eobjects.analyzer.job.tasks.InitializeReferenceDataTask;
import org.eobjects.analyzer.job.tasks.InitializeTask;
import org.eobjects.analyzer.job.tasks.RunExplorerTask;
import org.eobjects.analyzer.lifecycle.LifeCycleHelper;
import org.eobjects.analyzer.result.HasAnalyzerResult;
import org.eobjects.analyzer.util.SourceColumnFinder;
import org.eobjects.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnalysisRunnerJobDelegate {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisRunnerJobDelegate.class);
    private final AnalysisJob _job;
    private final AnalyzerBeansConfiguration _configuration;
    private final TaskRunner _taskRunner;
    private final AnalysisListener _analysisListener;
    private final Queue<JobAndResult> _resultQueue;
    private final ErrorAware _errorAware;
    private final Datastore _datastore;
    private final Collection<ExplorerJob> _explorerJobs;
    private final Collection<AnalyzerJob> _analyzerJobs;
    private final Collection<TransformerJob> _transformerJobs;
    private final Collection<FilterJob> _filterJobs;
    private final Collection<MergedOutcomeJob> _mergedOutcomeJobs;
    private final SourceColumnFinder _sourceColumnFinder;
    private final boolean _includeNonDistributedTasks;

    public AnalysisRunnerJobDelegate(AnalysisJob job, AnalyzerBeansConfiguration configuration, TaskRunner taskRunner, AnalysisListener analysisListener, Queue<JobAndResult> resultQueue, ErrorAware errorAware, boolean includeNonDistributedTasks) {
        this._job = job;
        this._configuration = configuration;
        this._taskRunner = taskRunner;
        this._analysisListener = analysisListener;
        this._resultQueue = resultQueue;
        this._includeNonDistributedTasks = includeNonDistributedTasks;
        this._sourceColumnFinder = new SourceColumnFinder();
        this._sourceColumnFinder.addSources(this._job);
        this._errorAware = errorAware;
        this._datastore = this._job.getDatastore();
        this._transformerJobs = this._job.getTransformerJobs();
        this._filterJobs = this._job.getFilterJobs();
        this._mergedOutcomeJobs = this._job.getMergedOutcomeJobs();
        this._explorerJobs = this._job.getExplorerJobs();
        this._analyzerJobs = this._job.getAnalyzerJobs();
    }

    public AnalysisResultFuture run() {
        try {
            InjectionManager injectionManager = this._configuration.getInjectionManager(this._job);
            LifeCycleHelper explorerLifeCycleHelper = new LifeCycleHelper(injectionManager, new ReferenceDataActivationManager(), this._includeNonDistributedTasks);
            LifeCycleHelper rowProcessingLifeCycleHelper = new LifeCycleHelper(injectionManager, new ReferenceDataActivationManager(), this._includeNonDistributedTasks);
            RowProcessingPublishers publishers = new RowProcessingPublishers(this._job, this._analysisListener, this._taskRunner, rowProcessingLifeCycleHelper, this._sourceColumnFinder);
            AnalysisJobMetrics analysisJobMetrics = publishers.getAnalysisJobMetrics();
            JobCompletionTaskListener jobCompletionTaskListener = new JobCompletionTaskListener(analysisJobMetrics, this._analysisListener, 2);
            this._analysisListener.jobBegin(this._job, analysisJobMetrics);
            this.validateSingleTableInput(this._transformerJobs);
            this.validateSingleTableInput(this._filterJobs);
            this.validateSingleTableInputForMergedOutcomes(this._mergedOutcomeJobs);
            this.validateSingleTableInput(this._analyzerJobs);
            this.scheduleExplorers(explorerLifeCycleHelper, jobCompletionTaskListener, analysisJobMetrics);
            this.scheduleRowProcessing(publishers, rowProcessingLifeCycleHelper, jobCompletionTaskListener, analysisJobMetrics);
            return new AnalysisResultFutureImpl(this._resultQueue, jobCompletionTaskListener, this._errorAware);
        }
        catch (RuntimeException e) {
            this._analysisListener.errorUknown(this._job, e);
            throw e;
        }
    }

    private void scheduleRowProcessing(RowProcessingPublishers publishers, LifeCycleHelper lifeCycleHelper, JobCompletionTaskListener jobCompletionTaskListener, AnalysisJobMetrics analysisJobMetrics) {
        logger.info("Created {} row processor publishers", (Object)publishers.size());
        ArrayList<TaskRunnable> finalTasks = new ArrayList<TaskRunnable>(2);
        finalTasks.add(new TaskRunnable(null, jobCompletionTaskListener));
        finalTasks.add(new TaskRunnable(null, new CloseReferenceDataTaskListener(lifeCycleHelper)));
        ForkTaskListener finalTaskListener = new ForkTaskListener("All row consumers finished", this._taskRunner, finalTasks);
        JoinTaskListener rowProcessorPublishersDoneCompletionListener = new JoinTaskListener(publishers.size(), finalTaskListener);
        Collection<RowProcessingPublisher> rowProcessingPublishers = publishers.getRowProcessingPublishers();
        for (RowProcessingPublisher rowProcessingPublisher : rowProcessingPublishers) {
            logger.debug("Scheduling row processing publisher: {}", (Object)rowProcessingPublisher);
            rowProcessingPublisher.runRowProcessing(this._resultQueue, rowProcessorPublishersDoneCompletionListener);
        }
    }

    private void scheduleExplorers(LifeCycleHelper lifeCycleHelper, JobCompletionTaskListener jobCompletionTaskListener, AnalysisJobMetrics analysisJobMetrics) {
        int numExplorerJobs = this._explorerJobs.size();
        if (numExplorerJobs == 0) {
            jobCompletionTaskListener.onComplete(null);
            return;
        }
        ArrayList<TaskRunnable> finalTasks = new ArrayList<TaskRunnable>();
        finalTasks.add(new TaskRunnable(null, jobCompletionTaskListener));
        finalTasks.add(new TaskRunnable(null, new CloseReferenceDataTaskListener(lifeCycleHelper)));
        JoinTaskListener explorersDoneTaskListener = new JoinTaskListener(numExplorerJobs, new ForkTaskListener("Exploring analyzers done", this._taskRunner, finalTasks));
        for (ExplorerJob explorerJob : this._explorerJobs) {
            ExplorerMetrics metrics = analysisJobMetrics.getExplorerMetrics(explorerJob);
            DatastoreConnection connection = this._datastore.openConnection();
            ExplorerBeanDescriptor<?> descriptor = explorerJob.getDescriptor();
            Explorer explorer = (Explorer)descriptor.newInstance();
            AtomicBoolean success = new AtomicBoolean(true);
            finalTasks.add(new TaskRunnable(null, new CloseResourcesTaskListener(new Closeable[]{connection})));
            finalTasks.add(new TaskRunnable(null, new CloseTaskListener(lifeCycleHelper, descriptor, explorer, success)));
            CollectResultsTask closeTask = new CollectResultsTask((HasAnalyzerResult<?>)explorer, this._job, explorerJob, (Collection<JobAndResult>)this._resultQueue, this._analysisListener);
            RunNextTaskTaskListener runFinishedListener = new RunNextTaskTaskListener(this._taskRunner, closeTask, explorersDoneTaskListener);
            RunExplorerTask runTask = new RunExplorerTask(explorer, metrics, this._datastore, this._analysisListener, success);
            RunNextTaskTaskListener referenceDataInitFinishedListener = new RunNextTaskTaskListener(this._taskRunner, runTask, runFinishedListener);
            InitializeReferenceDataTask initializeReferenceData = new InitializeReferenceDataTask(lifeCycleHelper);
            RunNextTaskTaskListener joinFinishedListener = new RunNextTaskTaskListener(this._taskRunner, initializeReferenceData, referenceDataInitFinishedListener);
            JoinTaskListener initializeFinishedListener = new JoinTaskListener(numExplorerJobs, joinFinishedListener);
            InitializeTask initTask = new InitializeTask(lifeCycleHelper, descriptor, explorer, explorerJob.getConfiguration());
            this._taskRunner.run(initTask, initializeFinishedListener);
        }
    }

    private void validateSingleTableInputForMergedOutcomes(Collection<MergedOutcomeJob> mergedOutcomeJobs) {
        Table originatingTable = null;
        for (MergedOutcomeJob mergedOutcomeJob : mergedOutcomeJobs) {
            MergeInput[] input;
            for (MergeInput mergeInput : input = mergedOutcomeJob.getMergeInputs()) {
                InputColumn<?>[] inputColumns;
                for (InputColumn<?> inputColumn : inputColumns = mergeInput.getInputColumns()) {
                    Table currentTable = this._sourceColumnFinder.findOriginatingTable(inputColumn);
                    if (currentTable == null) continue;
                    if (originatingTable == null) {
                        originatingTable = currentTable;
                        continue;
                    }
                    if (originatingTable.equals(currentTable)) continue;
                    throw new IllegalArgumentException("Input columns in " + mergeInput + " originate from different tables");
                }
            }
        }
    }

    private void validateSingleTableInput(Collection<? extends ConfigurableBeanJob<?>> beanJobs) {
        for (ConfigurableBeanJob<?> beanJob : beanJobs) {
            InputColumn[] input;
            Table originatingTable = null;
            for (InputColumn inputColumn : input = beanJob.getInput()) {
                Table table = this._sourceColumnFinder.findOriginatingTable(inputColumn);
                if (table == null) continue;
                if (originatingTable == null) {
                    originatingTable = table;
                    continue;
                }
                if (originatingTable.equals(table)) continue;
                throw new IllegalArgumentException("Input columns in " + beanJob + " originate from different tables");
            }
        }
    }
}

