/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.runner.AbstractRowProcessingConsumer;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.OutcomeSink;
import org.eobjects.analyzer.job.runner.RowProcessingChain;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;
import org.eobjects.analyzer.job.runner.RowProcessingPublishers;

final class AnalyzerConsumer
extends AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private final AnalysisJob _job;
    private final AnalyzerJob _analyzerJob;
    private final Analyzer<?> _analyzer;
    private final InputColumn<?>[] _inputColumns;
    private final AnalysisListener _analysisListener;
    private final boolean _concurrent;

    public AnalyzerConsumer(Analyzer<?> analyzer, AnalyzerJob analyzerJob, InputColumn<?>[] inputColumns, RowProcessingPublishers publishers) {
        super(analyzerJob, analyzerJob);
        this._analyzer = analyzer;
        this._analyzerJob = analyzerJob;
        this._inputColumns = inputColumns;
        if (publishers == null) {
            this._job = null;
            this._analysisListener = null;
        } else {
            this._job = publishers.getAnalysisJob();
            this._analysisListener = publishers.getAnalysisListener();
        }
        Concurrent concurrent = ((AnalyzerBeanDescriptor)analyzerJob.getDescriptor()).getAnnotation(Concurrent.class);
        this._concurrent = concurrent == null ? false : concurrent.value();
    }

    public Analyzer<?> getComponent() {
        return this._analyzer;
    }

    @Override
    public boolean isConcurrent() {
        return this._concurrent;
    }

    @Override
    public InputColumn<?>[] getRequiredInput() {
        return this._inputColumns;
    }

    @Override
    public void consume(InputRow row, int distinctCount, OutcomeSink outcomes, RowProcessingChain chain) {
        try {
            this._analyzer.run(row, distinctCount);
            chain.processNext(row, distinctCount, outcomes);
        }
        catch (RuntimeException e) {
            this._analysisListener.errorInAnalyzer(this._job, this._analyzerJob, row, e);
        }
    }

    @Override
    public AnalyzerJob getComponentJob() {
        return this._analyzerJob;
    }

    public String toString() {
        return "AnalyzerConsumer[" + this._analyzer + "]";
    }
}

