/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.runner.AnalysisJobMetrics;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.AnalyzerMetrics;
import org.eobjects.analyzer.job.runner.ExplorerMetrics;
import org.eobjects.analyzer.job.runner.RowProcessingMetrics;
import org.eobjects.analyzer.result.AnalyzerResult;

public final class CompositeAnalysisListener
implements AnalysisListener {
    private final List<AnalysisListener> _delegates;

    public CompositeAnalysisListener(AnalysisListener[] delegates) {
        this._delegates = new ArrayList<AnalysisListener>(delegates.length);
        for (AnalysisListener analysisListener : delegates) {
            this.addDelegate(analysisListener);
        }
    }

    public CompositeAnalysisListener(AnalysisListener firstDelegate, AnalysisListener ... delegates) {
        this._delegates = new ArrayList<AnalysisListener>(1 + delegates.length);
        this._delegates.add(firstDelegate);
        for (AnalysisListener analysisListener : delegates) {
            this.addDelegate(analysisListener);
        }
    }

    public void addDelegate(AnalysisListener analysisListener) {
        this._delegates.add(analysisListener);
    }

    public boolean isEmpty() {
        return this._delegates.isEmpty();
    }

    public int size() {
        return this._delegates.size();
    }

    @Override
    public void jobBegin(AnalysisJob job, AnalysisJobMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.jobBegin(job, metrics);
        }
    }

    @Override
    public void jobSuccess(AnalysisJob job, AnalysisJobMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.jobSuccess(job, metrics);
        }
    }

    @Override
    public void rowProcessingBegin(AnalysisJob job, RowProcessingMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.rowProcessingBegin(job, metrics);
        }
    }

    @Override
    public void rowProcessingProgress(AnalysisJob job, RowProcessingMetrics metrics, int currentRow) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.rowProcessingProgress(job, metrics, currentRow);
        }
    }

    @Override
    public void rowProcessingSuccess(AnalysisJob job, RowProcessingMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.rowProcessingSuccess(job, metrics);
        }
    }

    @Override
    public void analyzerBegin(AnalysisJob job, AnalyzerJob analyzerJob, AnalyzerMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.analyzerBegin(job, analyzerJob, metrics);
        }
    }

    @Override
    public void explorerBegin(AnalysisJob job, ExplorerJob explorerJob, ExplorerMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.explorerBegin(job, explorerJob, metrics);
        }
    }

    @Override
    public void explorerSuccess(AnalysisJob job, ExplorerJob explorerJob, AnalyzerResult result) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.explorerSuccess(job, explorerJob, result);
        }
    }

    @Override
    public void analyzerSuccess(AnalysisJob job, AnalyzerJob analyzerJob, AnalyzerResult result) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.analyzerSuccess(job, analyzerJob, result);
        }
    }

    @Override
    public void errorInFilter(AnalysisJob job, FilterJob filterJob, InputRow row, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.errorInFilter(job, filterJob, row, throwable);
        }
    }

    @Override
    public void errorInExplorer(AnalysisJob job, ExplorerJob explorerJob, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.errorInExplorer(job, explorerJob, throwable);
        }
    }

    @Override
    public void errorInTransformer(AnalysisJob job, TransformerJob transformerJob, InputRow row, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.errorInTransformer(job, transformerJob, row, throwable);
        }
    }

    @Override
    public void errorInAnalyzer(AnalysisJob job, AnalyzerJob analyzerJob, InputRow row, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.errorInAnalyzer(job, analyzerJob, row, throwable);
        }
    }

    @Override
    public void errorUknown(AnalysisJob job, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            delegate.errorUknown(job, throwable);
        }
    }
}

