/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.job.runner.OutcomeSink;
import org.eobjects.analyzer.job.runner.RowProcessingChain;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;

final class ConsumeRowHandlerDelegate
implements RowProcessingChain {
    private final List<RowProcessingConsumer> _consumers;
    private final InputRow _row;
    private final int _consumerIndex;
    private final OutcomeSink _outcomes;
    private final List<InputRow> _resultRecords;

    public ConsumeRowHandlerDelegate(List<RowProcessingConsumer> consumers, InputRow row, int consumerIndex, OutcomeSink outcomes) {
        this(consumers, row, consumerIndex, outcomes, new ArrayList<InputRow>(1));
    }

    private ConsumeRowHandlerDelegate(List<RowProcessingConsumer> consumers, InputRow row, int consumerIndex, OutcomeSink outcomes, List<InputRow> resultRecords) {
        this._consumers = consumers;
        this._row = row;
        this._consumerIndex = consumerIndex;
        this._outcomes = outcomes;
        this._resultRecords = resultRecords;
    }

    public List<InputRow> consume() {
        RowProcessingConsumer consumer = this._consumers.get(this._consumerIndex);
        boolean process = consumer.satisfiedForConsume(this._outcomes.getOutcomes(), this._row);
        if (process) {
            consumer.consume(this._row, 1, this._outcomes, this);
        } else {
            this.processNext(this._row, 1, this._outcomes);
        }
        return this._resultRecords;
    }

    @Override
    public void processNext(InputRow row, int distinctCount, OutcomeSink outcomes) {
        int nextIndex = this._consumerIndex + 1;
        if (nextIndex >= this._consumers.size()) {
            this._resultRecords.add(row);
            return;
        }
        ConsumeRowHandlerDelegate subDelegate = new ConsumeRowHandlerDelegate(this._consumers, row, nextIndex, outcomes, this._resultRecords);
        subDelegate.consume();
    }
}

