/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.concurrent.PreviousErrorsExistException;
import org.eobjects.analyzer.job.runner.AnalysisJobCancellation;
import org.eobjects.analyzer.job.runner.AnalysisJobMetrics;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.AnalyzerMetrics;
import org.eobjects.analyzer.job.runner.ErrorAware;
import org.eobjects.analyzer.job.runner.ExplorerMetrics;
import org.eobjects.analyzer.job.runner.RowProcessingMetrics;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ErrorAwareAnalysisListener
implements AnalysisListener,
ErrorAware {
    private static final Logger logger = LoggerFactory.getLogger(ErrorAwareAnalysisListener.class);
    private final List<Throwable> _errors = new LinkedList<Throwable>();
    private final AtomicBoolean _cancelled = new AtomicBoolean(false);

    ErrorAwareAnalysisListener() {
    }

    @Override
    public void jobBegin(AnalysisJob job, AnalysisJobMetrics metrics) {
    }

    @Override
    public void jobSuccess(AnalysisJob job, AnalysisJobMetrics metrics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleError(AnalysisJob job, Throwable throwable) {
        if (throwable instanceof AnalysisJobCancellation) {
            this._cancelled.set(true);
        }
        if (!(throwable instanceof PreviousErrorsExistException)) {
            logger.warn("Exception stack trace:", throwable);
        }
        List<Throwable> list = this._errors;
        synchronized (list) {
            if (!this._errors.contains(throwable)) {
                this._errors.add(throwable);
            }
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            SQLException nextException;
            if (!(t instanceof SQLException) || (nextException = ((SQLException)t).getNextException()) == null) continue;
            logger.warn("SQLException.getNextException() stack trace:", (Throwable)nextException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Throwable> getErrors() {
        ArrayList<Throwable> result;
        List<Throwable> list = this._errors;
        synchronized (list) {
            result = new ArrayList<Throwable>(this._errors);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isErrornous() {
        List<Throwable> list = this._errors;
        synchronized (list) {
            return !this._errors.isEmpty();
        }
    }

    @Override
    public void errorInFilter(AnalysisJob job, FilterJob filterJob, InputRow row, Throwable throwable) {
        logger.warn("errorInFilter({},{},{},{})", new Object[]{job, filterJob, row, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public void errorInTransformer(AnalysisJob job, TransformerJob transformerJob, InputRow row, Throwable throwable) {
        logger.warn("errorInTransformer({},{},{},{})", new Object[]{job, transformerJob, row, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public void errorInAnalyzer(AnalysisJob job, AnalyzerJob analyzerJob, InputRow row, Throwable throwable) {
        logger.warn("errorInAnalyzer({},{},{},{})", new Object[]{job, analyzerJob, row, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public void errorInExplorer(AnalysisJob job, ExplorerJob explorerJob, Throwable throwable) {
        logger.warn("errorInExplorer({},{},{})", new Object[]{job, explorerJob, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public void errorUknown(AnalysisJob job, Throwable throwable) {
        logger.warn("errorUnknown({},{})", new Object[]{job, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public void explorerBegin(AnalysisJob job, ExplorerJob explorerJob, ExplorerMetrics metrics) {
    }

    @Override
    public void explorerSuccess(AnalysisJob job, ExplorerJob explorerJob, AnalyzerResult result) {
    }

    @Override
    public void rowProcessingBegin(AnalysisJob job, RowProcessingMetrics metrics) {
    }

    @Override
    public void rowProcessingProgress(AnalysisJob job, RowProcessingMetrics metrics, int currentRow) {
    }

    @Override
    public void rowProcessingSuccess(AnalysisJob job, RowProcessingMetrics metrics) {
    }

    @Override
    public void analyzerBegin(AnalysisJob job, AnalyzerJob analyzerJob, AnalyzerMetrics metrics) {
    }

    @Override
    public void analyzerSuccess(AnalysisJob job, AnalyzerJob analyzerJob, AnalyzerResult result) {
    }

    @Override
    public boolean isCancelled() {
        return this._cancelled.get();
    }
}

