/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.List;
import org.eobjects.analyzer.job.concurrent.PreviousErrorsExistException;
import org.eobjects.analyzer.job.concurrent.TaskListener;
import org.eobjects.analyzer.job.concurrent.TaskRunnable;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.job.runner.ErrorAware;
import org.eobjects.analyzer.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ErrorAwareTaskRunnerWrapper
implements TaskRunner,
ErrorAware {
    private static final Logger logger = LoggerFactory.getLogger(ErrorAwareTaskRunnerWrapper.class);
    private static final PreviousErrorsExistException PREVIOUS_ERROR_EXCEPTION = new PreviousErrorsExistException("A previous exception has occurred");
    private final TaskRunner _taskRunner;
    private final ErrorAware _errorAware;

    public ErrorAwareTaskRunnerWrapper(ErrorAware errorAware, TaskRunner taskRunner) {
        this._taskRunner = taskRunner;
        this._errorAware = errorAware;
    }

    @Override
    public void run(Task task, TaskListener taskListener) {
        if (this.isErrornous()) {
            taskListener.onError(task, PREVIOUS_ERROR_EXCEPTION);
        } else if (this.isCancelled()) {
            logger.info("Ignoring task because job has been cancelled: {}", (Object)task);
            taskListener.onError(task, PREVIOUS_ERROR_EXCEPTION);
        } else {
            this._taskRunner.run(task, taskListener);
        }
    }

    @Override
    public void run(TaskRunnable taskRunnable) {
        this.run(taskRunnable.getTask(), taskRunnable.getListener());
    }

    @Override
    public void shutdown() {
        this._taskRunner.shutdown();
    }

    @Override
    public boolean isErrornous() {
        return this._errorAware.isErrornous();
    }

    @Override
    public List<Throwable> getErrors() {
        return this._errorAware.getErrors();
    }

    @Override
    public boolean isCancelled() {
        return this._errorAware.isCancelled();
    }

    @Override
    public void assistExecution() {
        if (!this.isErrornous() && !this.isCancelled()) {
            this._taskRunner.assistExecution();
        }
    }
}

