/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.Optimizeable;
import org.eobjects.analyzer.beans.api.QueryOptimizedFilter;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.ImmutableFilterOutcome;
import org.eobjects.analyzer.job.runner.AbstractRowProcessingConsumer;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.OutcomeSink;
import org.eobjects.analyzer.job.runner.RowProcessingChain;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;
import org.eobjects.analyzer.job.runner.RowProcessingPublishers;
import org.eobjects.analyzer.util.ReflectionUtils;

final class FilterConsumer
extends AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private final AnalysisJob _job;
    private final Filter<?> _filter;
    private final FilterJob _filterJob;
    private final InputColumn<?>[] _inputColumns;
    private final AnalysisListener _analysisListener;
    private final boolean _concurrent;

    public FilterConsumer(Filter<?> filter, FilterJob filterJob, InputColumn<?>[] inputColumns, RowProcessingPublishers publishers) {
        super(filterJob, filterJob);
        this._filter = filter;
        this._filterJob = filterJob;
        this._inputColumns = inputColumns;
        if (publishers == null) {
            this._job = null;
            this._analysisListener = null;
        } else {
            this._job = publishers.getAnalysisJob();
            this._analysisListener = publishers.getAnalysisListener();
        }
        Concurrent concurrent = ((FilterBeanDescriptor)filterJob.getDescriptor()).getAnnotation(Concurrent.class);
        this._concurrent = concurrent == null ? true : concurrent.value();
    }

    @Override
    public boolean isConcurrent() {
        return this._concurrent;
    }

    @Override
    public InputColumn<?>[] getRequiredInput() {
        return this._inputColumns;
    }

    public Filter<?> getComponent() {
        return this._filter;
    }

    @Override
    public void consume(InputRow row, int distinctCount, OutcomeSink outcomes, RowProcessingChain chain) {
        try {
            Enum category = this._filter.categorize(row);
            ImmutableFilterOutcome outcome = new ImmutableFilterOutcome(this._filterJob, category);
            outcomes.add(outcome);
            chain.processNext(row, distinctCount, outcomes);
        }
        catch (RuntimeException e) {
            this._analysisListener.errorInFilter(this._job, this._filterJob, row, e);
        }
    }

    @Override
    public FilterJob getComponentJob() {
        return this._filterJob;
    }

    public String toString() {
        return "FilterConsumer[" + this._filter + "]";
    }

    public boolean isQueryOptimizable(FilterOutcome filterOutcome) {
        if (this._filter instanceof QueryOptimizedFilter) {
            QueryOptimizedFilter queryOptimizedFilter = (QueryOptimizedFilter)this._filter;
            boolean optimizable = queryOptimizedFilter.isOptimizable(filterOutcome.getCategory());
            return optimizable;
        }
        return false;
    }

    public boolean isRemoveableUponOptimization() {
        Optimizeable optimizeable = ReflectionUtils.getAnnotation(((FilterBeanDescriptor)this._filterJob.getDescriptor()).getComponentClass(), Optimizeable.class);
        if (optimizeable == null) {
            return true;
        }
        return optimizeable.removeableUponOptimization();
    }
}

