/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.HashSet;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.data.TransformedInputRow;
import org.eobjects.analyzer.job.MergeInput;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.runner.AbstractRowProcessingConsumer;
import org.eobjects.analyzer.job.runner.OutcomeSink;
import org.eobjects.analyzer.job.runner.RowProcessingChain;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MergedOutcomeConsumer
extends AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private static final Logger logger = LoggerFactory.getLogger(MergedOutcomeConsumer.class);
    private final MergedOutcomeJob _mergedOutcomeJob;

    public MergedOutcomeConsumer(MergedOutcomeJob mergedOutcomeJob) {
        super(mergedOutcomeJob, mergedOutcomeJob);
        this._mergedOutcomeJob = mergedOutcomeJob;
    }

    public MergedOutcomeJob getMergedOutcomeJob() {
        return this._mergedOutcomeJob;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }

    @Override
    public Object getComponent() {
        return null;
    }

    @Override
    public InputColumn<?>[] getRequiredInput() {
        MergeInput[] mergeInputs;
        HashSet columns = new HashSet();
        for (MergeInput mergeInput : mergeInputs = this._mergedOutcomeJob.getMergeInputs()) {
            InputColumn<?>[] inputColumns;
            for (InputColumn<?> inputColumn : inputColumns = mergeInput.getInputColumns()) {
                columns.add(inputColumn);
            }
        }
        return columns.toArray(new InputColumn[columns.size()]);
    }

    @Override
    public InputColumn<?>[] getOutputColumns() {
        return this._mergedOutcomeJob.getOutput();
    }

    @Override
    public void consume(InputRow row, int distinctCount, OutcomeSink outcomes, RowProcessingChain chain) {
        TransformedInputRow result = new TransformedInputRow(row);
        InputColumn<?>[] output = this.getOutputColumns();
        if (output != null && output.length > 0) {
            MergeInput[] mergeInputs = this._mergedOutcomeJob.getMergeInputs();
            MergeInput currentMergeInput = null;
            for (MergeInput mergeInput : mergeInputs) {
                if (!outcomes.contains(mergeInput.getOutcome())) continue;
                currentMergeInput = mergeInput;
                break;
            }
            if (currentMergeInput == null) {
                logger.error("Could not determine current merge input state.\nAvailable outcomes are: {}\nMerged outcomes are: {}", (Object)outcomes.getOutcomes(), (Object)this._mergedOutcomeJob.getMergeInputs());
                throw new IllegalStateException("Could not determine current merge input state");
            }
            InputColumn<?>[] inputColumnsForCoalesce = currentMergeInput.getInputColumns();
            for (int i = 0; i < output.length; ++i) {
                InputColumn<?> currentColumn = output[i];
                result.addValue(currentColumn, row.getValue(inputColumnsForCoalesce[i]));
            }
        }
        outcomes.add(this._mergedOutcomeJob.getOutcome());
        chain.processNext(result, distinctCount, outcomes);
    }

    @Override
    public MergedOutcomeJob getComponentJob() {
        return this._mergedOutcomeJob;
    }

    public String toString() {
        return "MergedOutcomeConsumer[" + this._mergedOutcomeJob + "]";
    }
}

