/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReferenceDataActivationManager {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceDataActivationManager.class);
    private final Map<String, Dictionary> _dictionaries = new HashMap<String, Dictionary>();
    private final Map<String, SynonymCatalog> _synonymCatalogs = new HashMap<String, SynonymCatalog>();
    private final Map<String, StringPattern> _stringPatterns = new HashMap<String, StringPattern>();

    public Collection<Dictionary> getDictionaries() {
        return this._dictionaries.values();
    }

    public Collection<SynonymCatalog> getSynonymCatalogs() {
        return this._synonymCatalogs.values();
    }

    public Collection<StringPattern> getStringPatterns() {
        return this._stringPatterns.values();
    }

    public Collection<Object> getAllReferenceData() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.getDictionaries());
        result.addAll(this.getSynonymCatalogs());
        result.addAll(this.getStringPatterns());
        return result;
    }

    public void clearReferenceData() {
        this._dictionaries.clear();
        this._synonymCatalogs.clear();
        this._stringPatterns.clear();
    }

    public boolean accepts(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> c = obj.getClass();
        return ReflectionUtils.is(c, Dictionary.class) || ReflectionUtils.is(c, SynonymCatalog.class) || ReflectionUtils.is(c, StringPattern.class);
    }

    public void register(Object obj) {
        Class<?> c = obj.getClass();
        if (ReflectionUtils.is(c, Dictionary.class)) {
            Dictionary[] dictionaries = c.isArray() ? (Dictionary[])obj : new Dictionary[]{(Dictionary)obj};
            for (Dictionary dict : dictionaries) {
                this._dictionaries.put(dict.getName(), dict);
            }
        } else if (ReflectionUtils.is(c, SynonymCatalog.class)) {
            SynonymCatalog[] synonymCatalogs = c.isArray() ? (SynonymCatalog[])obj : new SynonymCatalog[]{(SynonymCatalog)obj};
            for (SynonymCatalog sc : synonymCatalogs) {
                this._synonymCatalogs.put(sc.getName(), sc);
            }
        } else if (ReflectionUtils.is(c, StringPattern.class)) {
            StringPattern[] stringPatterns = c.isArray() ? (StringPattern[])obj : new StringPattern[]{(StringPattern)obj};
            for (StringPattern sp : stringPatterns) {
                this._stringPatterns.put(sp.getName(), sp);
            }
        } else {
            logger.warn("Could not register unsupport object: {}", obj);
        }
    }
}

