/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eobjects.analyzer.data.ExpressionBasedInputColumn;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.InputColumnSourceJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;

class RowProcessingConsumerSorter {
    private final Collection<? extends RowProcessingConsumer> _consumers;

    public RowProcessingConsumerSorter(Collection<? extends RowProcessingConsumer> consumers) {
        this._consumers = consumers;
    }

    public List<RowProcessingConsumer> createProcessOrderedConsumerList() {
        ArrayList<RowProcessingConsumer> orderedConsumers = new ArrayList<RowProcessingConsumer>();
        LinkedList<? extends RowProcessingConsumer> remainingConsumers = new LinkedList<RowProcessingConsumer>(this._consumers);
        HashSet availableVirtualColumns = new HashSet();
        HashSet<Outcome> availableOutcomes = new HashSet<Outcome>();
        while (!remainingConsumers.isEmpty()) {
            boolean changed = false;
            Iterator it = remainingConsumers.iterator();
            while (it.hasNext()) {
                Outcome[] outcomes;
                InputColumn<?>[] requiredInput;
                InputColumn<?>[] requiredInput2;
                RowProcessingConsumer consumer = (RowProcessingConsumer)it.next();
                boolean accepted = true;
                accepted = consumer.satisfiedForFlowOrdering(availableOutcomes);
                if (accepted && (requiredInput2 = consumer.getRequiredInput()) != null) {
                    for (InputColumn<?> inputColumn : requiredInput2) {
                        if (inputColumn.isPhysicalColumn() || inputColumn instanceof ExpressionBasedInputColumn || availableVirtualColumns.contains(inputColumn)) continue;
                        accepted = false;
                        break;
                    }
                }
                if (!accepted) continue;
                orderedConsumers.add(consumer);
                it.remove();
                changed = true;
                ComponentJob componentJob = consumer.getComponentJob();
                for (InputColumn<?> inputColumn : requiredInput = consumer.getRequiredInput()) {
                    if (!(inputColumn instanceof ExpressionBasedInputColumn)) continue;
                    availableVirtualColumns.add(inputColumn);
                }
                if (componentJob instanceof InputColumnSourceJob) {
                    InputColumn<?>[] output;
                    for (InputColumn<?> col : output = ((InputColumnSourceJob)((Object)componentJob)).getOutput()) {
                        availableVirtualColumns.add(col);
                    }
                }
                if (!(componentJob instanceof OutcomeSourceJob)) continue;
                for (Outcome outcome : outcomes = ((OutcomeSourceJob)((Object)componentJob)).getOutcomes()) {
                    availableOutcomes.add(outcome);
                }
            }
            if (changed) continue;
            throw new IllegalStateException("Could not detect next consumer in processing order");
        }
        return orderedConsumers;
    }
}

