/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import org.eobjects.analyzer.beans.convert.ConvertToNumberTransformer;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.runner.AnalysisJobMetrics;
import org.eobjects.analyzer.job.runner.RowProcessingMetrics;
import org.eobjects.analyzer.job.runner.RowProcessingPublisher;
import org.eobjects.analyzer.job.runner.RowProcessingPublishers;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;

final class RowProcessingMetricsImpl
implements RowProcessingMetrics {
    private final RowProcessingPublishers _publishers;
    private final RowProcessingPublisher _publisher;
    private final Ref<Integer> _expectedRows;

    public RowProcessingMetricsImpl(RowProcessingPublishers publishers, RowProcessingPublisher publisher) {
        this._publishers = publishers;
        this._publisher = publisher;
        this._expectedRows = this.createExpectedRowsRef();
    }

    @Override
    public AnalysisJobMetrics getAnalysisJobMetrics() {
        return this._publishers.getAnalysisJobMetrics();
    }

    @Override
    public Query getQuery() {
        return this._publisher.getQuery();
    }

    @Override
    public Table getTable() {
        return this._publisher.getTable();
    }

    @Override
    public int getExpectedRows() {
        Integer expectedRows = (Integer)this._expectedRows.get();
        return expectedRows;
    }

    @Override
    public AnalyzerJob[] getAnalyzerJobs() {
        return this._publisher.getAnalyzerJobs();
    }

    private Ref<Integer> createExpectedRowsRef() {
        return new LazyRef<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Integer fetch() {
                int expectedRows = -1;
                Query originalQuery = RowProcessingMetricsImpl.this.getQuery();
                Query countQuery = originalQuery.clone();
                countQuery.setMaxRows(null);
                countQuery.getSelectClause().removeItems();
                countQuery.getOrderByClause().removeItems();
                countQuery.selectCount();
                ((SelectItem)countQuery.getSelectClause().getItem(0)).setFunctionApproximationAllowed(true);
                Datastore datastore = RowProcessingMetricsImpl.this._publishers.getDatastore();
                DatastoreConnection connection = datastore.openConnection();
                try {
                    DataSet countDataSet = connection.getDataContext().executeQuery(countQuery);
                    try {
                        Number count;
                        if (countDataSet.next() && (count = ConvertToNumberTransformer.transformValue(countDataSet.getRow().getValue(0))) != null) {
                            expectedRows = count.intValue();
                        }
                    }
                    finally {
                        countDataSet.close();
                    }
                }
                finally {
                    connection.close();
                }
                Integer maxRows = originalQuery.getMaxRows();
                if (maxRows != null) {
                    expectedRows = Math.min(expectedRows, maxRows);
                }
                return expectedRows;
            }
        };
    }
}

