/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MetaModelInputRow;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.BeanConfiguration;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.ConfigurableBeanJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.concurrent.ForkTaskListener;
import org.eobjects.analyzer.job.concurrent.JoinTaskListener;
import org.eobjects.analyzer.job.concurrent.RunNextTaskTaskListener;
import org.eobjects.analyzer.job.concurrent.TaskListener;
import org.eobjects.analyzer.job.concurrent.TaskRunnable;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.AnalyzerConsumer;
import org.eobjects.analyzer.job.runner.AnalyzerMetrics;
import org.eobjects.analyzer.job.runner.ConsumeRowHandler;
import org.eobjects.analyzer.job.runner.FilterConsumer;
import org.eobjects.analyzer.job.runner.JobAndResult;
import org.eobjects.analyzer.job.runner.MergedOutcomeConsumer;
import org.eobjects.analyzer.job.runner.RowConsumerTaskListener;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;
import org.eobjects.analyzer.job.runner.RowProcessingConsumerSorter;
import org.eobjects.analyzer.job.runner.RowProcessingMetrics;
import org.eobjects.analyzer.job.runner.RowProcessingMetricsImpl;
import org.eobjects.analyzer.job.runner.RowProcessingPublishers;
import org.eobjects.analyzer.job.runner.RowProcessingQueryOptimizer;
import org.eobjects.analyzer.job.runner.SimpleRowIdGenerator;
import org.eobjects.analyzer.job.runner.TransformerConsumer;
import org.eobjects.analyzer.job.tasks.CloseTaskListener;
import org.eobjects.analyzer.job.tasks.CollectResultsTask;
import org.eobjects.analyzer.job.tasks.ConsumeRowTask;
import org.eobjects.analyzer.job.tasks.InitializeReferenceDataTask;
import org.eobjects.analyzer.job.tasks.InitializeTask;
import org.eobjects.analyzer.job.tasks.RunRowProcessingPublisherTask;
import org.eobjects.analyzer.job.tasks.Task;
import org.eobjects.analyzer.lifecycle.LifeCycleHelper;
import org.eobjects.analyzer.result.HasAnalyzerResult;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.jdbc.JdbcDataContext;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RowProcessingPublisher {
    private static final Logger logger = LoggerFactory.getLogger(RowProcessingPublisher.class);
    private final RowProcessingPublishers _publishers;
    private final Table _table;
    private final Set<Column> _physicalColumns = new LinkedHashSet<Column>();
    private final List<RowProcessingConsumer> _consumers = new ArrayList<RowProcessingConsumer>();
    private final LazyRef<RowProcessingQueryOptimizer> _queryOptimizerRef;
    private final AtomicBoolean _successful = new AtomicBoolean(true);

    public RowProcessingPublisher(RowProcessingPublishers publishers, Table table) {
        if (publishers == null) {
            throw new IllegalArgumentException("RowProcessingPublishers cannot be null");
        }
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        this._publishers = publishers;
        this._table = table;
        this._queryOptimizerRef = this.createQueryOptimizerRef();
        if (!"true".equalsIgnoreCase("analyzerbeans.query.selectclause.optimize")) {
            Collection<InputColumn<?>> sourceColumns = publishers.getAnalysisJob().getSourceColumns();
            ArrayList<Column> columns = new ArrayList<Column>();
            for (InputColumn<?> sourceColumn : sourceColumns) {
                Column column = sourceColumn.getPhysicalColumn();
                if (column == null || !table.equals(column.getTable())) continue;
                columns.add(column);
            }
            this.addPhysicalColumns(columns.toArray(new Column[columns.size()]));
        }
    }

    public RowProcessingMetrics getRowProcessingMetrics() {
        RowProcessingMetricsImpl metrics = new RowProcessingMetricsImpl(this._publishers, this);
        return metrics;
    }

    public Table getTable() {
        return this._table;
    }

    public void addPrimaryKeysIfSourced() {
        Column[] primaryKeyColumns = this._table.getPrimaryKeys();
        if (primaryKeyColumns == null || primaryKeyColumns.length == 0) {
            logger.info("No primary keys defined for table {}, not pre-selecting primary keys", (Object)this._table.getName());
            return;
        }
        AnalysisJob analysisJob = this._publishers.getAnalysisJob();
        Collection<InputColumn<?>> sourceInputColumns = analysisJob.getSourceColumns();
        List sourceColumns = CollectionUtils.map(sourceInputColumns, (Func)new Func<InputColumn<?>, Column>(){

            public Column eval(InputColumn<?> inputColumn) {
                return inputColumn.getPhysicalColumn();
            }
        });
        for (Column primaryKeyColumn : primaryKeyColumns) {
            if (sourceColumns.contains(primaryKeyColumn)) continue;
            logger.info("Primary key column {} not added to source columns, not pre-selecting primary keys");
            return;
        }
        this.addPhysicalColumns(primaryKeyColumns);
    }

    private LazyRef<RowProcessingQueryOptimizer> createQueryOptimizerRef() {
        return new LazyRef<RowProcessingQueryOptimizer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected RowProcessingQueryOptimizer fetch() {
                Datastore datastore = RowProcessingPublisher.this._publishers.getDatastore();
                DatastoreConnection con = datastore.openConnection();
                try {
                    RowProcessingQueryOptimizer optimizer;
                    DataContext dataContext = con.getDataContext();
                    Column[] columnArray = RowProcessingPublisher.this._physicalColumns.toArray(new Column[RowProcessingPublisher.this._physicalColumns.size()]);
                    Query baseQuery = dataContext.query().from(RowProcessingPublisher.this._table).select(columnArray).toQuery();
                    logger.debug("Base query for row processing: {}", (Object)baseQuery);
                    List<RowProcessingConsumer> sortedConsumers = RowProcessingPublisher.sortConsumers(RowProcessingPublisher.this._consumers);
                    RowProcessingQueryOptimizer rowProcessingQueryOptimizer = optimizer = new RowProcessingQueryOptimizer(datastore, sortedConsumers, baseQuery);
                    return rowProcessingQueryOptimizer;
                }
                finally {
                    con.close();
                }
            }
        };
    }

    public static List<RowProcessingConsumer> sortConsumers(List<RowProcessingConsumer> consumers) {
        RowProcessingConsumerSorter sorter = new RowProcessingConsumerSorter(consumers);
        List<RowProcessingConsumer> sortedConsumers = sorter.createProcessOrderedConsumerList();
        if (logger.isDebugEnabled()) {
            logger.debug("Row processing order ({} consumers):", (Object)sortedConsumers.size());
            int i = 1;
            for (RowProcessingConsumer rowProcessingConsumer : sortedConsumers) {
                logger.debug(" {}) {}", (Object)i, (Object)rowProcessingConsumer);
                ++i;
            }
        }
        return sortedConsumers;
    }

    public void initialize() {
        this._queryOptimizerRef.requestLoad();
    }

    public void addPhysicalColumns(Column ... columns) {
        for (Column column : columns) {
            if (!this._table.equals(column.getTable())) {
                throw new IllegalArgumentException("Column does not pertain to the correct table. Expected table: " + this._table + ", actual table: " + column.getTable());
            }
            this._physicalColumns.add(column);
        }
    }

    private RowProcessingQueryOptimizer getQueryOptimizer() {
        return (RowProcessingQueryOptimizer)this._queryOptimizerRef.get();
    }

    public Query getQuery() {
        return this.getQueryOptimizer().getOptimizedQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRows(RowProcessingMetrics rowProcessingMetrics) {
        RowProcessingQueryOptimizer queryOptimizer = this.getQueryOptimizer();
        Query finalQuery = queryOptimizer.getOptimizedQuery();
        SimpleRowIdGenerator idGenerator = finalQuery.getFirstRow() == null ? new SimpleRowIdGenerator() : new SimpleRowIdGenerator(finalQuery.getFirstRow());
        AnalysisJob analysisJob = this._publishers.getAnalysisJob();
        AnalysisListener analysisListener = this._publishers.getAnalysisListener();
        TaskRunner taskRunner = this._publishers.getTaskRunner();
        for (RowProcessingConsumer rowProcessingConsumer : this._consumers) {
            if (rowProcessingConsumer instanceof AnalyzerConsumer) {
                AnalyzerConsumer analyzerConsumer = (AnalyzerConsumer)rowProcessingConsumer;
                AnalyzerJob analyzerJob = analyzerConsumer.getComponentJob();
                AnalyzerMetrics metrics = rowProcessingMetrics.getAnalysisJobMetrics().getAnalyzerMetrics(analyzerJob);
                analysisListener.analyzerBegin(analysisJob, analyzerJob, metrics);
            }
            if (!(rowProcessingConsumer instanceof TransformerConsumer)) continue;
            ((TransformerConsumer)rowProcessingConsumer).setRowIdGenerator(idGenerator);
        }
        List<RowProcessingConsumer> consumers = queryOptimizer.getOptimizedConsumers();
        Collection<? extends Outcome> availableOutcomes = queryOptimizer.getOptimizedAvailableOutcomes();
        analysisListener.rowProcessingBegin(analysisJob, rowProcessingMetrics);
        RowConsumerTaskListener taskListener = new RowConsumerTaskListener(analysisJob, analysisListener, taskRunner);
        Datastore datastore = this._publishers.getDatastore();
        DatastoreConnection con = datastore.openConnection();
        try {
            DataContext dataContext = con.getDataContext();
            if (logger.isDebugEnabled()) {
                String queryString;
                if (dataContext instanceof JdbcDataContext) {
                    JdbcDataContext jdbcDataContext = (JdbcDataContext)dataContext;
                    queryString = jdbcDataContext.getQueryRewriter().rewriteQuery(finalQuery);
                } else {
                    queryString = finalQuery.toSql();
                }
                logger.debug("Final query: {}", (Object)queryString);
                logger.debug("Final query firstRow={}, maxRows={}", (Object)finalQuery.getFirstRow(), (Object)finalQuery.getMaxRows());
            }
            DataSet dataSet = dataContext.executeQuery(finalQuery);
            int numTasks = 0;
            try {
                ConsumeRowHandler consumeRowHandler = new ConsumeRowHandler(consumers, availableOutcomes);
                while (dataSet.next()) {
                    if (taskListener.isErrornous()) {
                        break;
                    }
                    Row metaModelRow = dataSet.getRow();
                    int rowId = idGenerator.nextPhysicalRowId();
                    MetaModelInputRow inputRow = new MetaModelInputRow(rowId, metaModelRow);
                    ConsumeRowTask task = new ConsumeRowTask(consumeRowHandler, rowProcessingMetrics, inputRow, analysisListener);
                    taskRunner.run(task, taskListener);
                    ++numTasks;
                }
            }
            finally {
                dataSet.close();
            }
            taskListener.awaitTasks(numTasks);
        }
        finally {
            con.close();
        }
        if (taskListener.isErrornous()) {
            this._successful.set(false);
            return;
        }
        analysisListener.rowProcessingSuccess(analysisJob, rowProcessingMetrics);
    }

    public void addAnalyzerBean(Analyzer<?> analyzer, AnalyzerJob analyzerJob, InputColumn<?>[] inputColumns) {
        this.addConsumer(new AnalyzerConsumer(analyzer, analyzerJob, inputColumns, this._publishers));
    }

    public void addTransformerBean(Transformer<?> transformer, TransformerJob transformerJob, InputColumn<?>[] inputColumns) {
        this.addConsumer(new TransformerConsumer(transformer, transformerJob, inputColumns, this._publishers));
    }

    public void addFilterBean(Filter<?> filter, FilterJob filterJob, InputColumn<?>[] inputColumns) {
        this.addConsumer(new FilterConsumer(filter, filterJob, inputColumns, this._publishers));
    }

    public void addMergedOutcomeJob(MergedOutcomeJob mergedOutcomeJob) {
        this.addConsumer(new MergedOutcomeConsumer(mergedOutcomeJob));
    }

    public boolean containsOutcome(Outcome prerequisiteOutcome) {
        for (RowProcessingConsumer consumer : this._consumers) {
            Outcome[] outcomes;
            ComponentJob componentJob = consumer.getComponentJob();
            if (!(componentJob instanceof OutcomeSourceJob)) continue;
            for (Outcome outcome : outcomes = ((OutcomeSourceJob)((Object)componentJob)).getOutcomes()) {
                if (!outcome.satisfiesRequirement(prerequisiteOutcome)) continue;
                return true;
            }
        }
        return false;
    }

    private void addConsumer(RowProcessingConsumer consumer) {
        this._consumers.add(consumer);
    }

    public List<RowProcessingConsumer> getConfigurableConsumers() {
        List configurableConsumers = CollectionUtils.filter(this._consumers, (Predicate)new Predicate<RowProcessingConsumer>(){

            public Boolean eval(RowProcessingConsumer input) {
                return input.getComponentJob() instanceof ConfigurableBeanJob;
            }
        });
        return configurableConsumers;
    }

    public void runRowProcessing(Queue<JobAndResult> resultQueue, TaskListener finishedTaskListener) {
        LifeCycleHelper lifeCycleHelper = this._publishers.getLifeCycleHelper();
        TaskRunner taskRunner = this._publishers.getTaskRunner();
        List<RowProcessingConsumer> configurableConsumers = this.getConfigurableConsumers();
        int numConsumerTasks = configurableConsumers.size();
        JoinTaskListener closeTaskListener = new JoinTaskListener(numConsumerTasks, finishedTaskListener);
        ArrayList<TaskRunnable> closeTasks = new ArrayList<TaskRunnable>(numConsumerTasks);
        for (RowProcessingConsumer consumer : configurableConsumers) {
            closeTasks.add(this.createCloseTask(consumer, closeTaskListener));
        }
        ForkTaskListener getResultCompletionListener = new ForkTaskListener("collect results", taskRunner, closeTasks);
        JoinTaskListener getResultTaskListener = new JoinTaskListener(numConsumerTasks, getResultCompletionListener);
        ArrayList<TaskRunnable> getResultTasks = new ArrayList<TaskRunnable>();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            Task collectResultTask = this.createCollectResultTask(consumer, resultQueue);
            if (collectResultTask == null) {
                getResultTasks.add(new TaskRunnable(null, getResultTaskListener));
                continue;
            }
            getResultTasks.add(new TaskRunnable(collectResultTask, getResultTaskListener));
        }
        ForkTaskListener runCompletionListener = new ForkTaskListener("run row processing", taskRunner, getResultTasks);
        RowProcessingMetrics rowProcessingMetrics = this.getRowProcessingMetrics();
        RunRowProcessingPublisherTask runTask = new RunRowProcessingPublisherTask(this, rowProcessingMetrics);
        ForkTaskListener referenceDataInitFinishedListener = new ForkTaskListener("Initialize row consumers", taskRunner, Arrays.asList(new TaskRunnable(runTask, runCompletionListener)));
        RunNextTaskTaskListener initializeFinishedListener = new RunNextTaskTaskListener(taskRunner, new InitializeReferenceDataTask(lifeCycleHelper), referenceDataInitFinishedListener);
        this.initializeConsumers(initializeFinishedListener);
    }

    public void initializeConsumers(TaskListener finishedListener) {
        List<RowProcessingConsumer> configurableConsumers = this.getConfigurableConsumers();
        int numConfigurableConsumers = configurableConsumers.size();
        JoinTaskListener initFinishedListener = new JoinTaskListener(numConfigurableConsumers, finishedListener);
        TaskRunner taskRunner = this._publishers.getTaskRunner();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            TaskRunnable task = this.createInitTask(consumer, initFinishedListener);
            taskRunner.run(task);
        }
    }

    public void closeConsumers() {
        List<RowProcessingConsumer> configurableConsumers = this.getConfigurableConsumers();
        TaskRunner taskRunner = this._publishers.getTaskRunner();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            TaskRunnable task = this.createCloseTask(consumer, null);
            taskRunner.run(task);
        }
    }

    private Task createCollectResultTask(RowProcessingConsumer consumer, Queue<JobAndResult> resultQueue) {
        if (consumer instanceof TransformerConsumer || consumer instanceof FilterConsumer) {
            return null;
        }
        if (consumer instanceof AnalyzerConsumer) {
            AnalyzerConsumer analyzerConsumer = (AnalyzerConsumer)consumer;
            Analyzer<?> analyzer = analyzerConsumer.getComponent();
            AnalysisJob analysisJob = this._publishers.getAnalysisJob();
            AnalysisListener analysisListener = this._publishers.getAnalysisListener();
            return new CollectResultsTask((HasAnalyzerResult<?>)analyzer, analysisJob, consumer.getComponentJob(), (Collection<JobAndResult>)resultQueue, analysisListener);
        }
        throw new IllegalStateException("Unknown consumer type: " + consumer);
    }

    private TaskRunnable createCloseTask(RowProcessingConsumer consumer, TaskListener closeTaskListener) {
        LifeCycleHelper lifeCycleHelper = this._publishers.getLifeCycleHelper();
        ComponentDescriptor<?> descriptor = consumer.getComponentJob().getDescriptor();
        Object component = consumer.getComponent();
        return new TaskRunnable(null, new CloseTaskListener(lifeCycleHelper, descriptor, component, this._successful, closeTaskListener));
    }

    private TaskRunnable createInitTask(RowProcessingConsumer consumer, TaskListener listener) {
        ComponentJob componentJob = consumer.getComponentJob();
        Object component = consumer.getComponent();
        BeanConfiguration configuration = ((ConfigurableBeanJob)componentJob).getConfiguration();
        ComponentDescriptor<?> descriptor = componentJob.getDescriptor();
        LifeCycleHelper lifeCycleHelper = this._publishers.getLifeCycleHelper();
        InitializeTask task = new InitializeTask(lifeCycleHelper, descriptor, component, configuration);
        return new TaskRunnable(task, listener);
    }

    public String toString() {
        return "RowProcessingPublisher[table=" + this._table.getQualifiedLabel() + ", consumers=" + this._consumers.size() + "]";
    }

    public AnalyzerJob[] getAnalyzerJobs() {
        ArrayList<AnalyzerJob> analyzerJobs = new ArrayList<AnalyzerJob>();
        for (RowProcessingConsumer consumer : this._consumers) {
            if (!(consumer instanceof AnalyzerConsumer)) continue;
            AnalyzerJob analyzerJob = ((AnalyzerConsumer)consumer).getComponentJob();
            analyzerJobs.add(analyzerJob);
        }
        return analyzerJobs.toArray(new AnalyzerJob[analyzerJobs.size()]);
    }
}

