/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ConfigurableBeanJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.MergeInput;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.job.runner.AnalysisJobMetrics;
import org.eobjects.analyzer.job.runner.AnalysisJobMetricsImpl;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.RowProcessingPublisher;
import org.eobjects.analyzer.lifecycle.LifeCycleHelper;
import org.eobjects.analyzer.util.SourceColumnFinder;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

public final class RowProcessingPublishers {
    private final AnalysisJob _analysisJob;
    private final AnalysisListener _analysisListener;
    private final TaskRunner _taskRunner;
    private final LifeCycleHelper _lifeCycleHelper;
    private final SourceColumnFinder _sourceColumnFinder;
    private final Map<Table, RowProcessingPublisher> _rowProcessingPublishers;

    public RowProcessingPublishers(AnalysisJob analysisJob, AnalysisListener analysisListener, TaskRunner taskRunner, LifeCycleHelper lifeCycleHelper, SourceColumnFinder sourceColumnFinder) {
        this._analysisJob = analysisJob;
        this._analysisListener = analysisListener;
        this._taskRunner = taskRunner;
        this._lifeCycleHelper = lifeCycleHelper;
        if (sourceColumnFinder == null) {
            this._sourceColumnFinder = new SourceColumnFinder();
            this._sourceColumnFinder.addSources(this._analysisJob);
        } else {
            this._sourceColumnFinder = sourceColumnFinder;
        }
        this._rowProcessingPublishers = new HashMap<Table, RowProcessingPublisher>();
        this.initialize();
    }

    private void initialize() {
        for (FilterJob filterJob : this._analysisJob.getFilterJobs()) {
            this.registerRowProcessingPublishers(filterJob);
        }
        for (MergedOutcomeJob mergedOutcomeJob : this._analysisJob.getMergedOutcomeJobs()) {
            this.registerRowProcessingPublishers(mergedOutcomeJob);
        }
        for (TransformerJob transformerJob : this._analysisJob.getTransformerJobs()) {
            this.registerRowProcessingPublishers(transformerJob);
        }
        for (AnalyzerJob analyzerJob : this._analysisJob.getAnalyzerJobs()) {
            this.registerRowProcessingPublishers(analyzerJob);
        }
        for (RowProcessingPublisher publisher : this._rowProcessingPublishers.values()) {
            publisher.initialize();
        }
    }

    public Column[] getPhysicalColumns(ConfigurableBeanJob<?> componentJob) {
        Outcome[] requirements;
        InputColumn[] inputColumns;
        HashSet<Column> physicalColumns = new HashSet<Column>();
        for (InputColumn inputColumn : inputColumns = componentJob.getInput()) {
            physicalColumns.addAll(this._sourceColumnFinder.findOriginatingColumns(inputColumn));
        }
        for (Outcome requirement : requirements = componentJob.getRequirements()) {
            physicalColumns.addAll(this._sourceColumnFinder.findOriginatingColumns(requirement));
        }
        Column[] physicalColumnsArray = physicalColumns.toArray(new Column[physicalColumns.size()]);
        return physicalColumnsArray;
    }

    public Table[] getTables(ConfigurableBeanJob<?> componentJob) {
        return this.getTables(componentJob, null);
    }

    public Table[] getTables(ConfigurableBeanJob<?> componentJob, Column[] physicalColumns) {
        Table[] tables;
        if (physicalColumns == null) {
            physicalColumns = this.getPhysicalColumns(componentJob);
        }
        if (physicalColumns.length == 0) {
            HashSet<Table> allTables = new HashSet<Table>();
            Collection<InputColumn<?>> allSourceColumns = this._analysisJob.getSourceColumns();
            for (InputColumn<?> inputColumn : allSourceColumns) {
                allTables.add(inputColumn.getPhysicalColumn().getTable());
            }
            tables = allTables.toArray(new Table[allTables.size()]);
        } else {
            tables = MetaModelHelper.getTables((Column[])physicalColumns);
        }
        if (tables.length > 1) {
            throw new IllegalStateException("Component has input columns from multiple tables: " + componentJob);
        }
        if (tables.length == 0) {
            throw new IllegalStateException("Component has no dependent tables: " + componentJob);
        }
        return tables;
    }

    private void registerRowProcessingPublishers(ConfigurableBeanJob<?> componentJob) {
        Table[] tables;
        Column[] physicalColumns = this.getPhysicalColumns(componentJob);
        for (Table table : tables = this.getTables(componentJob, physicalColumns)) {
            RowProcessingPublisher rowPublisher = this._rowProcessingPublishers.get(table);
            if (rowPublisher == null) {
                rowPublisher = new RowProcessingPublisher(this, table);
                rowPublisher.addPrimaryKeysIfSourced();
                this._rowProcessingPublishers.put(table, rowPublisher);
            }
            rowPublisher.addPhysicalColumns(physicalColumns);
            InputColumn<?>[] localInputColumns = this.getLocalInputColumns(table, componentJob.getInput());
            if (componentJob instanceof AnalyzerJob) {
                AnalyzerJob analyzerJob = (AnalyzerJob)componentJob;
                Analyzer analyzer = (Analyzer)((AnalyzerBeanDescriptor)analyzerJob.getDescriptor()).newInstance();
                rowPublisher.addAnalyzerBean(analyzer, analyzerJob, localInputColumns);
                continue;
            }
            if (componentJob instanceof TransformerJob) {
                TransformerJob transformerJob = (TransformerJob)componentJob;
                Transformer transformer = (Transformer)((TransformerBeanDescriptor)transformerJob.getDescriptor()).newInstance();
                rowPublisher.addTransformerBean(transformer, transformerJob, localInputColumns);
                continue;
            }
            if (componentJob instanceof FilterJob) {
                FilterJob filterJob = (FilterJob)componentJob;
                Filter filter = (Filter)((FilterBeanDescriptor)filterJob.getDescriptor()).newInstance();
                rowPublisher.addFilterBean(filter, filterJob, localInputColumns);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported component job type: " + componentJob);
        }
    }

    private InputColumn<?>[] getLocalInputColumns(Table table, InputColumn<?>[] inputColumns) {
        if (table == null || inputColumns == null || inputColumns.length == 0) {
            return new InputColumn[0];
        }
        ArrayList result = new ArrayList();
        block0: for (InputColumn<?> inputColumn : inputColumns) {
            Set<Column> sourcePhysicalColumns = this._sourceColumnFinder.findOriginatingColumns(inputColumn);
            for (Column physicalColumn : sourcePhysicalColumns) {
                if (!table.equals(physicalColumn.getTable())) continue;
                result.add(inputColumn);
                continue block0;
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    private void registerRowProcessingPublishers(MergedOutcomeJob mergedOutcomeJob) {
        Collection<RowProcessingPublisher> publishers = this._rowProcessingPublishers.values();
        for (RowProcessingPublisher rowProcessingPublisher : publishers) {
            MergeInput[] mergeInputs;
            boolean prerequisiteOutcomesExist = true;
            for (MergeInput mergeInput : mergeInputs = mergedOutcomeJob.getMergeInputs()) {
                Outcome prerequisiteOutcome = mergeInput.getOutcome();
                if (rowProcessingPublisher.containsOutcome(prerequisiteOutcome)) continue;
                prerequisiteOutcomesExist = false;
                break;
            }
            if (!prerequisiteOutcomesExist) continue;
            rowProcessingPublisher.addMergedOutcomeJob(mergedOutcomeJob);
        }
    }

    public int size() {
        return this._rowProcessingPublishers.size();
    }

    public RowProcessingPublisher getRowProcessingPublisher(Table table) {
        return this._rowProcessingPublishers.get(table);
    }

    public Collection<RowProcessingPublisher> getRowProcessingPublishers() {
        return this._rowProcessingPublishers.values();
    }

    public Table[] getTables() {
        Set<Table> tables = this._rowProcessingPublishers.keySet();
        return tables.toArray(new Table[tables.size()]);
    }

    public AnalysisJobMetrics getAnalysisJobMetrics() {
        return new AnalysisJobMetricsImpl(this._analysisJob, this);
    }

    protected AnalysisJob getAnalysisJob() {
        return this._analysisJob;
    }

    protected AnalysisListener getAnalysisListener() {
        return this._analysisListener;
    }

    protected LifeCycleHelper getLifeCycleHelper() {
        return this._lifeCycleHelper;
    }

    protected TaskRunner getTaskRunner() {
        return this._taskRunner;
    }

    public Datastore getDatastore() {
        return this._analysisJob.getDatastore();
    }
}

