/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.QueryOptimizedFilter;
import org.eobjects.analyzer.beans.filter.MaxRowsFilter;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.InputColumnSinkJob;
import org.eobjects.analyzer.job.InputColumnSourceJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSinkJob;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.runner.FilterConsumer;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;
import org.eobjects.metamodel.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowProcessingQueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(RowProcessingQueryOptimizer.class);
    private static final Class<?>[] ALWAYS_OPTIMIZABLE = new Class[]{MaxRowsFilter.class};
    private final Datastore _datastore;
    private final Query _baseQuery;
    private final List<RowProcessingConsumer> _consumers;
    private final Map<FilterConsumer, FilterOutcome> _optimizedFilters;

    public RowProcessingQueryOptimizer(Datastore datastore, List<RowProcessingConsumer> consumers, Query baseQuery) {
        this._datastore = datastore;
        this._consumers = consumers;
        this._baseQuery = baseQuery;
        this._optimizedFilters = new HashMap<FilterConsumer, FilterOutcome>();
        this.init();
    }

    private void init() {
        int consumerIndex = 0;
        for (RowProcessingConsumer consumer : this._consumers) {
            if (consumer instanceof FilterConsumer) {
                FilterConsumer filterConsumer = (FilterConsumer)consumer;
                if (!this.isOptimizable(filterConsumer)) {
                    logger.debug("Breaking optimization. Not optimizable: {}", (Object)filterConsumer);
                    break;
                }
                FilterOutcome[] outcomes = filterConsumer.getComponentJob().getOutcomes();
                FilterOutcome optimizableOutcome = null;
                for (FilterOutcome outcome : outcomes) {
                    boolean optimizable = this.isOptimizable(filterConsumer, outcome, consumerIndex);
                    if (!optimizable) continue;
                    if (optimizableOutcome != null) break;
                    optimizableOutcome = outcome;
                }
                if (optimizableOutcome == null) break;
                this._optimizedFilters.put(filterConsumer, optimizableOutcome);
            }
            ++consumerIndex;
        }
    }

    private boolean isOptimizable(FilterConsumer filterConsumer) {
        InputColumn<?>[] input;
        FilterBeanDescriptor descriptor = (FilterBeanDescriptor)filterConsumer.getComponentJob().getDescriptor();
        if (!descriptor.isQueryOptimizable()) {
            logger.debug("FilterBeanDescriptor not optimizable: {}", (Object)descriptor);
            return false;
        }
        for (InputColumn<?> inputColumn : input = filterConsumer.getRequiredInput()) {
            if (!inputColumn.isVirtualColumn()) continue;
            logger.debug("InputColumn is virtual: {}, so filter is not optimizable: {}", inputColumn, (Object)filterConsumer);
            return false;
        }
        return true;
    }

    private boolean isOptimizable(FilterConsumer filterConsumer, FilterOutcome filterOutcome, int consumerIndex) {
        Class filterClass;
        if (!filterConsumer.isQueryOptimizable(filterOutcome)) {
            return false;
        }
        if (!this._datastore.getPerformanceCharacteristics().isQueryOptimizationPreferred() && !ArrayUtils.contains((Object[])ALWAYS_OPTIMIZABLE, filterClass = ((FilterBeanDescriptor)filterConsumer.getComponentJob().getDescriptor()).getComponentClass())) {
            logger.debug("Datastore performance characteristics indicate that query optimization will not improve performance for {}, stopping", (Object)filterConsumer);
            return false;
        }
        HashSet<Outcome> satisfiedColumns = new HashSet<Outcome>();
        HashSet<Outcome> satisfiedRequirements = new HashSet<Outcome>();
        satisfiedRequirements.add(filterOutcome);
        for (int i = consumerIndex + 1; i < this._consumers.size(); ++i) {
            boolean independentComponent = true;
            RowProcessingConsumer nextConsumer = this._consumers.get(i);
            ComponentJob componentJob = nextConsumer.getComponentJob();
            if (componentJob instanceof OutcomeSinkJob) {
                Outcome[] requirements;
                for (Outcome outcome : requirements = ((OutcomeSinkJob)((Object)componentJob)).getRequirements()) {
                    if (!satisfiedRequirements.contains(outcome)) {
                        logger.debug("Requirement {} is not met using query optimization of {}", (Object)outcome, (Object)filterConsumer);
                        return false;
                    }
                    independentComponent = false;
                }
            }
            if (componentJob instanceof InputColumnSinkJob) {
                InputColumn<?>[] requiredColumns = ((InputColumnSinkJob)((Object)componentJob)).getInput();
                for (Outcome outcome : requiredColumns) {
                    if (!outcome.isVirtualColumn()) continue;
                    if (!satisfiedColumns.contains(outcome)) {
                        logger.debug("InputColumn {} is available at query time, and therefore not satisfied for query optimization of {}", (Object)outcome, (Object)filterConsumer);
                        return false;
                    }
                    independentComponent = false;
                }
            }
            if (independentComponent) {
                logger.debug("Component {} is completely independent. Position in chain is not determinable, so optimization cannot be done.", (Object)filterConsumer);
                return false;
            }
            if (componentJob instanceof OutcomeSourceJob) {
                Outcome[] outcomes = ((OutcomeSourceJob)((Object)componentJob)).getOutcomes();
                for (Outcome outcome : outcomes) {
                    satisfiedRequirements.add(outcome);
                }
            }
            if (!(componentJob instanceof InputColumnSourceJob)) continue;
            InputColumn<?>[] output = ((InputColumnSourceJob)((Object)componentJob)).getOutput();
            for (Outcome outcome : output) {
                satisfiedColumns.add(outcome);
            }
        }
        return true;
    }

    public Query getOptimizedQuery() {
        Query q = this._baseQuery.clone();
        Set<Map.Entry<FilterConsumer, FilterOutcome>> entries = this._optimizedFilters.entrySet();
        for (Map.Entry<FilterConsumer, FilterOutcome> entry : entries) {
            Query newQuery;
            FilterConsumer consumer = entry.getKey();
            FilterOutcome outcome = entry.getValue();
            Filter<?> filter = consumer.getComponent();
            QueryOptimizedFilter queryOptimizedFilter = (QueryOptimizedFilter)filter;
            q = newQuery = queryOptimizedFilter.optimizeQuery(q, outcome.getCategory());
        }
        return q;
    }

    public List<RowProcessingConsumer> getOptimizedConsumers() {
        ArrayList<RowProcessingConsumer> result = new ArrayList<RowProcessingConsumer>(this._consumers);
        for (FilterConsumer filterConsumer : this._optimizedFilters.keySet()) {
            if (!filterConsumer.isRemoveableUponOptimization()) continue;
            result.remove(filterConsumer);
        }
        return result;
    }

    public Collection<? extends Outcome> getOptimizedAvailableOutcomes() {
        return this._optimizedFilters.values();
    }

    public boolean isOptimizable() {
        return !this._optimizedFilters.isEmpty();
    }
}

