/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.runner;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.OutputRowCollector;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.data.TransformedInputRow;
import org.eobjects.analyzer.descriptors.ProvidedPropertyDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.concurrent.ThreadLocalOutputRowCollector;
import org.eobjects.analyzer.job.runner.AbstractRowProcessingConsumer;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.OutcomeSink;
import org.eobjects.analyzer.job.runner.RowIdGenerator;
import org.eobjects.analyzer.job.runner.RowProcessingChain;
import org.eobjects.analyzer.job.runner.RowProcessingConsumer;
import org.eobjects.analyzer.job.runner.RowProcessingPublishers;

final class TransformerConsumer
extends AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private final AnalysisJob _job;
    private final Transformer<?> _transformer;
    private final TransformerJob _transformerJob;
    private final InputColumn<?>[] _inputColumns;
    private final AnalysisListener _analysisListener;
    private final boolean _concurrent;
    private RowIdGenerator _idGenerator;

    public TransformerConsumer(Transformer<?> transformer, TransformerJob transformerJob, InputColumn<?>[] inputColumns, RowProcessingPublishers publishers) {
        super(transformerJob, transformerJob);
        this._transformer = transformer;
        this._transformerJob = transformerJob;
        this._inputColumns = inputColumns;
        if (publishers == null) {
            this._job = null;
            this._analysisListener = null;
        } else {
            this._job = publishers.getAnalysisJob();
            this._analysisListener = publishers.getAnalysisListener();
        }
        Concurrent concurrent = ((TransformerBeanDescriptor)this._transformerJob.getDescriptor()).getAnnotation(Concurrent.class);
        this._concurrent = concurrent == null ? true : concurrent.value();
    }

    public void setRowIdGenerator(RowIdGenerator idGenerator) {
        this._idGenerator = idGenerator;
    }

    @Override
    public boolean isConcurrent() {
        return this._concurrent;
    }

    @Override
    public InputColumn<?>[] getRequiredInput() {
        return this._inputColumns;
    }

    public Transformer<?> getComponent() {
        return this._transformer;
    }

    @Override
    public InputColumn<?>[] getOutputColumns() {
        return this._transformerJob.getOutput();
    }

    @Override
    public void consume(InputRow row, int distinctCount, OutcomeSink outcomes, RowProcessingChain chain) {
        InputColumn<?>[] outputColumns = this.getOutputColumns();
        this.registerListener(this._transformer, row, outcomes, chain, outputColumns);
        try {
            Object[] values = this._transformer.transform(row);
            if (values == null) {
                return;
            }
            TransformedInputRow resultRow = row instanceof TransformedInputRow ? (TransformedInputRow)row : new TransformedInputRow(row);
            this.addValuesToRow(resultRow, outputColumns, values);
            chain.processNext(resultRow, distinctCount, outcomes);
        }
        catch (RuntimeException e) {
            this._analysisListener.errorInTransformer(this._job, this._transformerJob, row, e);
        }
        this.unregisterListener(this._transformer);
    }

    private void unregisterListener(Transformer<?> transformer) {
        Set<ProvidedPropertyDescriptor> outputRowCollectorProperties = ((TransformerBeanDescriptor)this._transformerJob.getDescriptor()).getProvidedPropertiesByType(OutputRowCollector.class);
        for (ProvidedPropertyDescriptor descriptor : outputRowCollectorProperties) {
            OutputRowCollector outputRowCollector = (OutputRowCollector)descriptor.getValue(transformer);
            if (!(outputRowCollector instanceof ThreadLocalOutputRowCollector)) continue;
            ((ThreadLocalOutputRowCollector)outputRowCollector).removeListener();
        }
    }

    private void registerListener(Transformer<?> transformer, final InputRow row, final OutcomeSink outcomes, final RowProcessingChain chain, final InputColumn<?>[] outputColumns) {
        Set<ProvidedPropertyDescriptor> outputRowCollectorProperties = ((TransformerBeanDescriptor)this._transformerJob.getDescriptor()).getProvidedPropertiesByType(OutputRowCollector.class);
        if (outputRowCollectorProperties == null || outputRowCollectorProperties.isEmpty()) {
            return;
        }
        ThreadLocalOutputRowCollector.Listener listener = new ThreadLocalOutputRowCollector.Listener(){
            private AtomicInteger recordNumber = new AtomicInteger(0);

            @Override
            public void onValues(Object[] values) {
                int recordNo = this.recordNumber.incrementAndGet();
                boolean isFirst = recordNo == 1;
                TransformedInputRow resultRow = isFirst ? new TransformedInputRow(row) : new TransformedInputRow(row, TransformerConsumer.this.getNextVirtualRowId(row, recordNo));
                TransformerConsumer.this.addValuesToRow(resultRow, outputColumns, values);
                OutcomeSink clonedOutcomeSink = outcomes.clone();
                chain.processNext(resultRow, 1, clonedOutcomeSink);
            }
        };
        for (ProvidedPropertyDescriptor descriptor : outputRowCollectorProperties) {
            OutputRowCollector outputRowCollector = (OutputRowCollector)descriptor.getValue(transformer);
            if (outputRowCollector instanceof ThreadLocalOutputRowCollector) {
                ((ThreadLocalOutputRowCollector)outputRowCollector).setListener(listener);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported output row collector type: " + outputRowCollector);
        }
    }

    private int getNextVirtualRowId(InputRow row, int recordNo) {
        if (this._idGenerator == null) {
            int offset = Integer.MAX_VALUE;
            int hiLoIntervalOffset = row.getId() * 1000;
            return offset - hiLoIntervalOffset + recordNo;
        }
        return this._idGenerator.nextVirtualRowId();
    }

    private void addValuesToRow(TransformedInputRow resultRow, InputColumn<?>[] outputColumns, Object[] values) {
        assert (outputColumns.length == values.length);
        for (int i = 0; i < outputColumns.length; ++i) {
            Object value = i < values.length ? values[i] : null;
            InputColumn<?> column = outputColumns[i];
            resultRow.addValue(column, value);
        }
    }

    @Override
    public TransformerJob getComponentJob() {
        return this._transformerJob;
    }

    public String toString() {
        return "TransformerConsumer[" + this._transformer + "]";
    }
}

