/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.tasks;

import java.io.Closeable;
import org.eobjects.analyzer.job.concurrent.TaskListener;
import org.eobjects.analyzer.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseResourcesTaskListener
implements TaskListener {
    private static final Logger logger = LoggerFactory.getLogger(CloseResourcesTaskListener.class);
    private final Closeable[] _closeables;

    public CloseResourcesTaskListener(Closeable ... closeables) {
        this._closeables = closeables;
    }

    @Override
    public void onBegin(Task task) {
    }

    private void cleanup() {
        for (int i = 0; i < this._closeables.length; ++i) {
            try {
                this._closeables[i].close();
                continue;
            }
            catch (Exception e) {
                logger.error("Could not close resource: " + this._closeables[i], (Throwable)e);
            }
        }
    }

    @Override
    public void onComplete(Task task) {
        this.cleanup();
    }

    @Override
    public void onError(Task task, Throwable throwable) {
        this.cleanup();
    }
}

