/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.tasks;

import java.util.Collection;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.JobAndResult;
import org.eobjects.analyzer.job.tasks.Task;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.HasAnalyzerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectResultsTask
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(CollectResultsTask.class);
    private final HasAnalyzerResult<?> _hasResult;
    private final Collection<JobAndResult> _results;
    private final AnalysisListener _analysisListener;
    private final AnalysisJob _job;
    private final ComponentJob _componentJob;

    public CollectResultsTask(HasAnalyzerResult<?> hasResult, AnalysisJob job, ComponentJob componentJob, Collection<JobAndResult> results, AnalysisListener analysisListener) {
        this._hasResult = hasResult;
        this._job = job;
        this._componentJob = componentJob;
        this._results = results;
        this._analysisListener = analysisListener;
    }

    @Override
    public void execute() throws Exception {
        logger.debug("execute()");
        AnalyzerResult result = this._hasResult.getResult();
        if (result == null) {
            throw new IllegalStateException("Analyzer result (from " + this._hasResult + ") was null");
        }
        if (this._hasResult instanceof Analyzer) {
            this._analysisListener.analyzerSuccess(this._job, (AnalyzerJob)this._componentJob, result);
        } else if (this._hasResult instanceof Explorer) {
            this._analysisListener.explorerSuccess(this._job, (ExplorerJob)this._componentJob, result);
        } else {
            throw new UnsupportedOperationException("Unsupported component type: " + this._hasResult);
        }
        this._results.add(new JobAndResult(this._componentJob, result));
    }
}

