/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.job.tasks;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eobjects.analyzer.beans.api.Explorer;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.ExplorerMetrics;
import org.eobjects.analyzer.job.tasks.Task;
import org.eobjects.metamodel.DataContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RunExplorerTask
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(RunExplorerTask.class);
    private final Explorer<?> _explorer;
    private final Datastore _datastore;
    private final AnalysisListener _analysisListener;
    private final ExplorerMetrics _explorerMetrics;
    private final AtomicBoolean _success;

    public RunExplorerTask(Explorer<?> explorer, ExplorerMetrics explorerMetrics, Datastore datastore, AnalysisListener analysisListener, AtomicBoolean success) {
        this._explorer = explorer;
        this._explorerMetrics = explorerMetrics;
        this._datastore = datastore;
        this._analysisListener = analysisListener;
        this._success = success;
    }

    @Override
    public void execute() throws Exception {
        logger.debug("execute()");
        if (this._analysisListener != null) {
            this._analysisListener.explorerBegin(this._explorerMetrics.getAnalysisJobMetrics().getAnalysisJob(), this._explorerMetrics.getExplorerJob(), this._explorerMetrics);
        }
        DatastoreConnection con = this._datastore.openConnection();
        DataContext dc = con.getDataContext();
        try {
            this._explorer.run(dc);
        }
        catch (Exception e) {
            this._success.set(false);
            throw e;
        }
        finally {
            con.close();
        }
    }
}

